% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/substr.R
\name{substr}
\alias{substr}
\alias{substrl}
\alias{substr<-}
\alias{substrl<-}
\alias{gsubstr}
\alias{gsubstrl}
\alias{gsubstr<-}
\alias{gsubstrl<-}
\alias{substring}
\alias{substring<-}
\title{Extract or Replace Substrings}
\usage{
substr(x, start = 1L, stop = -1L)

substrl(
  x,
  start = 1L,
  length = attr(start, "match.length"),
  ignore_negative_length = FALSE
)

substr(x, start = 1L, stop = -1L) <- value

substrl(x, start = 1L, length = attr(start, "match.length")) <- value

gsubstr(x, start = list(1L), stop = list(-1L))

gsubstrl(
  x,
  start = list(1L),
  length = lapply(start, attr, "match.length"),
  ignore_negative_length = TRUE
)

gsubstr(x, start = list(1L), stop = list(-1L)) <- value

gsubstrl(x, start = list(1L), length = lapply(start, attr, "match.length")) <- value

substring(text, first = 1L, last = -1L)

substring(text, first = 1L, last = -1L) <- value
}
\arguments{
\item{x, text}{character vector
whose parts are to be extracted/replaced}

\item{start, first}{numeric vector (for \code{substr})
or list of numeric vectors (for \code{gsubstr})
giving the start indexes;
e.g., 1 denotes the first code point;
negative indexes
count from the end of a string, i.e., -1 is the last character}

\item{stop, last}{numeric vector (for \code{substr})
or list of numeric vectors (for \code{gsubstr})
giving the end indexes (inclusive);
note that if the start position is farther than the
end position, this indicates an empty substring therein (see Examples)}

\item{length}{numeric vector  (for \code{substr})
or list of numeric vectors (for \code{gsubstr})
giving the substring lengths;
negative lengths result in a missing value or empty vector
(see \code{ignore_negative_length}) or the corresponding
substring being unchanged}

\item{ignore_negative_length}{single logical value;
whether negative lengths should be ignored or yield missing values}

\item{value}{character vector  (for \code{substr})
or list of character vectors  (for \code{gsubstr})
defining the replacements strings}
}
\value{
\code{substr} and \code{substrl} return a character vector (in UTF-8).
\code{gsubstr} and \code{gsubstrl} return a list of character vectors.

Their replacement versions modify \code{x} 'in-place' (see Examples).

The attributes are copied from the longest arguments (similar to
binary operators).
}
\description{
\code{substr} and \code{substrl} extract
contiguous parts of given character strings.
The former operates based on start and end positions
while the latter is fed with substring lengths.

Their replacement versions allow for substituting parts of strings
with new content.

\code{gsubstr} and \code{gsubstrl} allow for extracting or replacing
multiple chunks from each string.
}
\details{
Not to be confused with \code{\link{sub}}.

\code{substring} is a [DEPRECATED] synonym for \code{substr}.

Note that these functions can break some meaningful Unicode code point
sequences, e.g., when inputs are not normalised. For extracting
initial parts of strings based on character width, see \code{\link{strtrim}}.

Note that \code{gsubstr} (and related functions) expect
\code{start}, \code{stop}, \code{length}, and \code{value}
to be lists. Non-list arguments will be converted by calling
\code{\link[base]{as.list}}. This is different from the default policy
applied by \code{\link[stringi]{stri_sub_all}}, which calls
\code{\link[base]{list}}.

Note that \code{substrl} and \code{gsubstrl} are
interoperable with \code{\link{regexpr2}} and \code{\link{gregexpr2}},
respectively, and hence can be considered as substituted for the
[DEPRECATED] \code{\link[base]{regmatches}} (which is more specialised).
}
\section{Differences from Base R}{

Replacements for and enhancements of base \code{\link[base]{substr}}
and \code{\link[base]{substring}}
implemented with \code{\link[stringi]{stri_sub}} and
\code{\link[stringi]{stri_sub_all}},

\itemize{
\item \code{substring} is "for compatibility with S", but this should
    no longer matter
    \bold{[here, \code{substring} is equivalent to \code{substr}; in a
    future version, using the former may result in a warning]}
\item \code{substr} is not vectorised with respect to all the arguments
    (and \code{substring} is not fully vectorised wrt \code{value})
    \bold{[fixed here]}
\item not all attributes are taken from the longest of the inputs
    \bold{[fixed here]}
\item partial recycling with no warning
    \bold{[fixed here]}
\item the replacement must be of the same length as the chunk
    being substituted \bold{[fixed here]}
\item negative indexes are silently treated as 1
    \bold{[changed here: negative indexes count from the end of the string]}
\item replacement of different length than the extracted substring
    never changes the length of the string
    \bold{[changed here -- output length is input length minus
    length of extracted plus length of replacement]}
\item \code{\link{regexpr}} (amongst others) return start positions
    and lengths of matches, but base \code{substr} only uses
    start and end
    \bold{[fixed by introducing \code{substrl}]}
\item there is no function to extract or replace multiple
    chunks in each string (other than \code{\link{regmatches}}
    that works on outputs generated by \code{\link[base]{gregexpr}} et al.)
    \bold{[fixed by introducing \code{gsubstrl}]}
}
}

\examples{
x <- "spam, spam, bacon, and spam"
base::substr(x, c(1, 13), c(4, 17))
base::substring(x, c(1, 13), c(4, 17))
substr(x, c(1, 13), c(4, 17))
substrl(x, c(1, 13), c(4, 5))

# replacement function used as an ordinary one - return a copy of x:
base::`substr<-`(x, 1, 4, value="jam")
`substr<-`(x, 1, 4, value="jam")
base::`substr<-`(x, 1, 4, value="porridge")
`substr<-`(x, 1, 4, value="porridge")

# interoperability with gregexpr2:
p <- "[\\\\w&&[^a]][\\\\w&&[^n]][\\\\w&&[^d]]\\\\w+"  # regex: all words but 'and'
gsubstrl(x, gregexpr2(x, p))
`gsubstrl<-`(x, gregexpr2(x, p), value=list(c("a", "b", "c", "d")))

# replacement function modifying x in-place:
substr(x, 1, 4) <- "eggs"
substr(x, 1, 0) <- "porridge, "        # prepend (start<stop)
substr(x, nchar(x)+1) <- " every day"  # append (start<stop)
print(x)



}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{strtrim}}, \code{\link{nchar}},
   \code{\link{startsWith}}, \code{\link{endsWith}},
   \code{\link{gregexpr}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
