% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_calendar.R
\name{stri_datetime_fields}
\alias{stri_datetime_fields}
\title{Get Values for Date and Time Fields}
\usage{
stri_datetime_fields(time, tz = attr(time, "tzone"), locale = NULL)
}
\arguments{
\item{time}{an object of class \code{\link{POSIXct}} or an object coercible to}

\item{tz}{\code{NULL} or \code{''} for the default time zone or
a single string with time zone identifier, see \code{\link{stri_timezone_list}}}

\item{locale}{\code{NULL} or \code{''} for the current default locale,
or a single string with a locale identifier; a non-Gregorian calendar
may be specified by setting \code{@calendar=name} keyword}
}
\value{
Returns a data frame with the following columns:
\enumerate{
\item Year (0 is 1BC, -1 is 2BC, etc.)
\item Month (1-based, i.e., 1 stands for the first month, e.g., January;
note that the number of months depends on the selected calendar,
see \code{\link{stri_datetime_symbols}})
\item Day
\item Hour (24-h clock)
\item Minute
\item Second
\item Millisecond
\item WeekOfYear (this is locale-dependent)
\item WeekOfMonth (this is locale-dependent)
\item DayOfYear
\item DayOfWeek (1-based, 1 denotes Sunday; see \code{\link{stri_datetime_symbols}})
\item Hour12 (12-h clock)
\item AmPm (see \code{\link{stri_datetime_symbols}})
\item Era (see \code{\link{stri_datetime_symbols}})
}
}
\description{
Computes and returns values for all date and time fields.
}
\details{
Vectorized over \code{time}.
}
\examples{
stri_datetime_fields(stri_datetime_now())
stri_datetime_fields(stri_datetime_now(), locale='@calendar=hebrew')
stri_datetime_symbols(locale='@calendar=hebrew')$Month[
   stri_datetime_fields(stri_datetime_now(), locale='@calendar=hebrew')$Month
]

}
\seealso{
Other datetime: 
\code{\link{stri_datetime_add}()},
\code{\link{stri_datetime_create}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_fstr}()},
\code{\link{stri_datetime_now}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}
}
\concept{datetime}
