% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_wrap}
\alias{stri_wrap}
\title{Word Wrap Text to Format Paragraphs}
\usage{
stri_wrap(str, width = floor(0.9 * getOption("width")), cost_exponent = 2,
  simplify = TRUE, locale = NULL)
}
\arguments{
\item{str}{character vector of strings to reformat}

\item{width}{single positive integer giving the desired
maximal number of code points per line}

\item{cost_exponent}{single numeric value, values not greater than zero
will select a greedy word-wrapping algorithm; otherwise
this value denotes the exponent in the cost function
of a (more aesthetic) dynamic programming-based algorithm
(values in [2, 3] are recommended)}

\item{simplify}{single logical value, see Value}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}}
}
\value{
If \code{simplify} is \code{TRUE}, then a character vector is returned.
Otherwise, you will get a list of \code{length(str)} character vectors.
}
\description{
This function breaks text paragraphs into lines,
each consisting of at most \code{width} code points.
}
\details{
Vectorized over \code{str}.

Any of the strings must not contain \code{\\r}, \code{\\n},
or other new line characters, otherwise you will get at error.
You should split the input text into lines
or e.g. substitute line breaks with spaces
before applying this function.

Multiple white spaces between the word boundaries are
preserved withing each wrapped line. If you wish to substitute
all such sequences with single spaces, call e.g.
\code{stri_trim(stri_replace_all_charclass(str, "\\p{WHITE_SPACE}", " ", TRUE))}
prior to string wrapping.

The greedy algorithm (for \code{cost_exponent} being non-positive)
provides a very simple way for word wrapping.
It always puts as many words in each line as possible.
This method -- contrary to the dynamic algorithm -- does not minimize
the number of space left at the end of every line.
The dynamic algorithm (a.k.a. Knuth's word wrapping algorithm)
is more complex, but it returns text wrapped
in a more aesthetic way. This method minimizes the squared
(by default, see \code{cost_exponent}) number of spaces  (raggedness)
at the end of each line, so the text is mode arranged evenly.

Note that Unicode code points may have various widths when
printed on screen. This function acts like each code point
is of width 1. This function should rather be used with
text in Latin script.

\pkg{ICU}'s line-\code{BreakIterator} is used to determine
text boundaries at which a line break is possible.
}
\examples{
s <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit. Proin "\%+\%
      "nibh augue, suscipit a, scelerisque sed, lacinia in, mi. Cras vel "\%+\%
      "lorem. Etiam pellentesque aliquet tellus."
cat(stri_wrap(s, 20, 0.0), sep="\\n") # greedy
cat(stri_wrap(s, 20, 2.0), sep="\\n") # dynamic
cat(stri_pad(stri_wrap(s), side='both'), sep="\\n")
}
\references{
D.E. Knuth, M.F. Plass,
Breaking paragraphs into lines, \emph{Software: Practice and Experience} 11(11),
1981, pp. 1119--1184
}
\seealso{
Other locale_sensitive: \code{\link{\%!==\%}},
  \code{\link{\%!=\%}}, \code{\link{\%<=\%}},
  \code{\link{\%<\%}}, \code{\link{\%===\%}},
  \code{\link{\%==\%}}, \code{\link{\%>=\%}},
  \code{\link{\%>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}

Other text_boundaries: \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_split_boundaries}}
}

