/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.labs.samoa.instances;

import com.yahoo.labs.samoa.instances.Prediction;
import java.io.Serializable;
import moa.core.DoubleVector;

public class MultiLabelPrediction
implements Prediction,
Serializable {
    protected DoubleVector[] prediction;

    public MultiLabelPrediction() {
        this(0);
    }

    public MultiLabelPrediction(int numOutputAttributes) {
        this.prediction = new DoubleVector[numOutputAttributes];
        for (int i = 0; i < numOutputAttributes; ++i) {
            this.prediction[i] = new DoubleVector();
        }
    }

    @Override
    public int numOutputAttributes() {
        return this.prediction.length;
    }

    @Override
    public int numClasses(int outputAttributeIndex) {
        int ret = 0;
        if (this.prediction.length > outputAttributeIndex) {
            ret = this.prediction[outputAttributeIndex].numValues();
        }
        return ret;
    }

    @Override
    public double[] getVotes(int outputAttributeIndex) {
        double[] ret = null;
        if (this.prediction.length > outputAttributeIndex) {
            ret = this.prediction[outputAttributeIndex].getArrayCopy();
        }
        return ret;
    }

    @Override
    public double[] getVotes() {
        return this.getVotes(0);
    }

    @Override
    public double getVote(int outputAttributeIndex, int classIndex) {
        double ret = 0.0;
        if (this.prediction.length > outputAttributeIndex) {
            ret = this.prediction[outputAttributeIndex].getValue(classIndex);
        }
        return ret;
    }

    @Override
    public void setVotes(int outputAttributeIndex, double[] votes) {
        for (int i = 0; i < votes.length; ++i) {
            this.prediction[outputAttributeIndex].setValue(i, votes[i]);
        }
    }

    @Override
    public void setVotes(double[] votes) {
        this.setVotes(0, votes);
    }

    @Override
    public void setVote(int outputAttributeIndex, int classIndex, double vote) {
        this.prediction[outputAttributeIndex].setValue(classIndex, vote);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.prediction.length; ++i) {
            sb.append("Out " + i + ": ");
            for (int c = 0; c < this.prediction[i].numValues(); ++c) {
                sb.append((double)((int)(this.prediction[i].getValue(c) * 1000.0)) / 1000.0 + " ");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean hasVotesForAttribute(int outputAttributeIndex) {
        if (this.prediction.length < outputAttributeIndex + 1) {
            return false;
        }
        return this.prediction[outputAttributeIndex].numValues() != 0;
    }

    @Override
    public int size() {
        return this.prediction.length;
    }
}

