/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.errormeasurers;

import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.rules.errormeasurers.ErrorMeasurement;

public class RootMeanSquaredError
extends ErrorMeasurement {
    private static final long serialVersionUID = 1L;
    private double weightSeen = 0.0;
    private double sumSquaredError = 0.0;

    @Override
    public double getCurrentError() {
        if (this.weightSeen == 0.0) {
            return Double.MAX_VALUE;
        }
        return Math.sqrt(this.sumSquaredError / this.weightSeen);
    }

    @Override
    public void addPrediction(double[] prediction, Instance inst) {
        double error = prediction[0] - inst.classValue();
        this.sumSquaredError = error * error * inst.weight() + this.fadingErrorFactor * this.sumSquaredError;
        this.weightSeen = inst.weight() + this.fadingErrorFactor * this.weightSeen;
    }
}

