/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.Iterator;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SilhouetteCoefficient
extends MeasureCollection {
    private double pointInclusionProbThreshold = 0.8;

    @Override
    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[]{false};
        return defaults;
    }

    @Override
    public String[] getNames() {
        String[] names = new String[]{"SilhCoeff"};
        return names;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) {
        int numFCluster = clustering.size();
        double[][] pointInclusionProbFC = new double[points.size()][numFCluster];
        for (int p = 0; p < points.size(); ++p) {
            DataPoint point = points.get(p);
            for (int fc = 0; fc < numFCluster; ++fc) {
                Cluster cl = clustering.get(fc);
                pointInclusionProbFC[p][fc] = cl.getInclusionProbability(point);
            }
        }
        double silhCoeff = 0.0;
        int totalCount = 0;
        for (int p = 0; p < points.size(); ++p) {
            DataPoint point = points.get(p);
            ArrayList<Integer> ownClusters = new ArrayList<Integer>();
            for (int fc = 0; fc < numFCluster; ++fc) {
                if (!(pointInclusionProbFC[p][fc] > this.pointInclusionProbThreshold)) continue;
                ownClusters.add(fc);
            }
            if (ownClusters.size() <= 0) continue;
            double[] distanceByClusters = new double[numFCluster];
            int[] countsByClusters = new int[numFCluster];
            for (int p1 = 0; p1 < points.size(); ++p1) {
                DataPoint point1 = points.get(p1);
                if (p1 == p || point1.classValue() == -1.0) continue;
                for (int fc = 0; fc < numFCluster; ++fc) {
                    if (!(pointInclusionProbFC[p1][fc] > this.pointInclusionProbThreshold)) continue;
                    double distance = this.distance(point, point1);
                    int n = fc;
                    distanceByClusters[n] = distanceByClusters[n] + distance;
                    int n2 = fc;
                    countsByClusters[n2] = countsByClusters[n2] + 1;
                }
            }
            double minAvgDistanceOwn = Double.MAX_VALUE;
            int minOwnIndex = -1;
            Iterator i$ = ownClusters.iterator();
            while (i$.hasNext()) {
                int fc = (Integer)i$.next();
                double normDist = distanceByClusters[fc] / (double)countsByClusters[fc];
                if (!(normDist < minAvgDistanceOwn)) continue;
                minAvgDistanceOwn = normDist;
                minOwnIndex = fc;
            }
            double minAvgDistanceOther = Double.MAX_VALUE;
            for (int fc = 0; fc < numFCluster; ++fc) {
                double normDist;
                if (fc == minOwnIndex || !((normDist = distanceByClusters[fc] / (double)countsByClusters[fc]) < minAvgDistanceOther)) continue;
                minAvgDistanceOther = normDist;
            }
            double silhP = (minAvgDistanceOther - minAvgDistanceOwn) / Math.max(minAvgDistanceOther, minAvgDistanceOwn);
            point.setMeasureValue("SC - own", minAvgDistanceOwn);
            point.setMeasureValue("SC - other", minAvgDistanceOther);
            point.setMeasureValue("SC", silhP);
            silhCoeff += silhP;
            ++totalCount;
        }
        if (totalCount > 0) {
            silhCoeff /= (double)totalCount;
        }
        silhCoeff = (silhCoeff + 1.0) / 2.0;
        this.addValue(0, silhCoeff);
    }

    private double distance(DataPoint inst1, DataPoint inst2) {
        double distance = 0.0;
        int numDims = inst1.numAttributes();
        for (int i = 0; i < numDims; ++i) {
            double d = inst1.value(i) - inst2.value(i);
            distance += d * d;
        }
        return Math.sqrt(distance);
    }
}

