% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tajimasD.R
\name{tajimasD}
\alias{tajimasD}
\title{Tajima's D}
\usage{
tajimasD(x, CI = 0.95)
}
\arguments{
\item{x}{set of DNA sequences or a haploid \linkS4class{gtypes} 
object with sequences.}

\item{CI}{desired central confidence interval.}
}
\value{
A named vector with the estimate for \code{D} and 
  the \code{p.value} that it is different from 0.
}
\description{
Calculate Tajima's D for a set of sequences to test 
  for selection.
}
\examples{
data(dolph.seqs)

tajimasD(dolph.seqs)

}
\references{
Tajima, F. 1989. Statistical method for testing the neutral 
  mutation hypothesis by DNA polymorphism. Genetics 123:585-595.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
