% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/structure.read.R, R/structure.run.R, R/structure.write.R
\name{structure.read}
\alias{structure}
\alias{structure.read}
\alias{structure.run}
\alias{structure.write}
\title{STRUCTURE}
\usage{
structure.read(file, pops = NULL)

structure.run(g, k.range = NULL, num.k.rep = 1, label = NULL,
  delete.files = TRUE, num.cores = 1, ...)

structure.write(g, label = NULL, maxpops = length(unique(g$genotypes[,
  "strata"])), burnin = 1000, numreps = 1000, noadmix = TRUE,
  freqscorr = FALSE, randomize = TRUE, seed = 0, pop.prior = NULL,
  locpriorinit = 1, maxlocprior = 20, gensback = 2, migrprior = 0.05,
  pfrompopflagonly = TRUE, popflag = NULL, ...)
}
\arguments{
\item{file}{name of the output file from STRUCTURE.}

\item{pops}{vector of population labels to be used in place of numbers in STRUCTURE file.}

\item{g}{a \code{\link{gtypes}} object.}

\item{k.range}{vector of values to for \code{maxpop} in multiple runs. If set to \code{NULL}, a single STRUCTURE run is
conducted with \code{maxpops} groups. If specified, do not also specify \code{maxpops}.}

\item{num.k.rep}{number of replicates for each value in \code{k.range}.}

\item{label}{label to use for input and output files}

\item{delete.files}{logical. Delete all files when STRUCTURE is finished?}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}

\item{...}{arguments to be passed to \code{structure.write}.}

\item{maxpops}{number of groups.}

\item{burnin}{number of iterations for MCMC burnin.}

\item{numreps}{number of MCMC replicates.}

\item{noadmix}{logical. No admixture?}

\item{freqscorr}{logical. Correlated frequencies?}

\item{randomize}{randomize.}

\item{seed}{set random seed.}

\item{pop.prior}{a character specifying which population prior model to use, "locprior" or "usepopinfo".}

\item{locpriorinit}{parameterizes locprior parameter \emph{r} - how informative the populations are. Only used when \code{pop.prior} = "locprior".}

\item{maxlocprior}{specifies range of locprior parameter \emph{r}. Only used when \code{pop.prior} = "locprior".}

\item{gensback}{integer defining the number of generations back to test for immigrant ancestry. Only used when \code{pop.prior} = "usepopinfo".}

\item{migrprior}{numeric between 0 and 1 listing migration prior. Only used when \code{pop.prior} = "usepopinfo".}

\item{pfrompopflagonly}{logical. update allele frequencies from individuals specified by \code{popflag}. Only used when \code{pop.prior} = "usepopinfo".}

\item{popflag}{a vector of integers (0, 1) or logicals identifiying whether or not to use strata information. Only used when \code{pop.prior} = "usepopinfo".}
}
\value{
\describe{
 \item{structure.run}{a list where each element is a list with results from \code{structure.read} and a vector of the filenames used.}
 \item{structure.write}{a vector of the filenames used by STRUCTURE.}
 \item{structure.read}{a list containing:
   \tabular{ll}{
     \code{summary} \tab new locus name, which is a combination of loci in group.\cr
     \code{q.mat} \tab data.frame of assignment probabilities for each id.\cr
     \code{prior.anc} \tab list of prior ancestry estimates for each individual where population priors were used.\cr
     \code{files} \tab vector of input and output files used by STRUCTURE.\cr
     \code{label} \tab label for the run.\cr
   }
 }
}
}
\description{
Run STRUCTURE to assess group membership of samples.
}
\examples{
\dontrun{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5, description = "msats")

# Run STRUCTURE
sr <- structure.run(msats, k.range = 1:6, num.k.rep = 10)

# Calculate Evanno metrics
evno <- structure.evanno(sr)
print(evno)

# Run CLUMPP to combine runs for K = 2
clumpp <- clumpp.run(sr, k = 3)
print(clumpp)

# Plot CLUMPP results
structure.plot(clumpp)
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Pritchard, J.K., M. Stephens, P. Donnelly. 2000. Inference of population structure using
multilocus genotype data. Genetics 155:945-959. \url{http://pritchardlab.stanford.edu/structure.html}
}
\seealso{
\code{\link{structure.plot}}, \code{\link{structure.evanno}}, \code{\link{clumpp}}
}

