% Generated by roxygen2 (4.0.2): do not edit by hand
\name{overall.test}
\alias{overall.test}
\alias{pairwise.test}
\alias{pop.diff.test}
\alias{stat.list}
\title{Population Differentiation Tests}
\usage{
overall.test(g, stats = "all", nrep = 1000, keep.null = FALSE,
  num.cores = 1, quietly = FALSE, write.output = FALSE, ...)

pairwise.test(g, stats = "all", nrep = 1000, keep.null = FALSE,
  num.cores = 1, quietly = FALSE, write.output = FALSE, ...)

pop.diff.test(g, stats = "all", overall = TRUE, pairwise = TRUE,
  nrep = 1000, keep.null = FALSE, num.cores = 1, quietly = FALSE,
  write.output = FALSE, ...)

stat.list(g, stats = "all")
}
\arguments{
\item{g}{a \code{\link{gtypes}} object.}

\item{stats}{a character vector specifying which anlayses to conduct. For haploid \code{g}, can contain
"fst", "phist", or "chi2", or for diploid \code{g}, can contain "fst", "fst.prime", "gst", "gst.prime",
"gst.dbl.prime", "d", or "chi2". The default is "all" which executes all available tests for given ploidy.}

\item{nrep}{number specifying number of permutation replicates to use for permutation test.}

\item{keep.null}{logical. Keep the null distribution from the permutation test?}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}

\item{quietly}{logical. Print progress output to screen?}

\item{write.output}{logical. Write a .csv file with results?}

\item{...}{other parameters to be passed to population differentiation functions.}

\item{overall}{logical. Calculate overall statistic of population differentiation?}

\item{pairwise}{logical. Calculate statistics of population differentiation between all pairs of strata?}
}
\value{
list with results
}
\description{
Conduct overall and/or pairwise tests of population differentiation.
}
\examples{
data(dolph.strata)
data(dolph.msats)
msat.merge <- merge(dolph.strata, dolph.msats, by = "ids", all.y = TRUE, sort = FALSE)
msats <- gtypes(msat.merge, id.col = 1, strata.col = 3, locus.col = 5, description = "msats")

# Conduct an overall test of differentiation
overall.test(msats, stats = "chi2", nrep = 20, write.output = FALSE)

# Conduct a pairwise test between all strata
pairwise.test(msats, stats = c("gst.prime", "gst.dbl.prime"), nrep = 20, write.output = FALSE)

# Conduct both overall and pairwise tests
result <- pop.diff.test(msats, stats = c("fst", "fst.prime"), nrep = 20, write.output = FALSE)
print(result$overall)
print(result$pairwise)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

