% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratEst_model.R
\name{stratEst.model}
\alias{stratEst.model}
\title{Strategy Estimation Function}
\usage{
stratEst.model(
  data,
  strategies,
  shares = NULL,
  coefficients = NULL,
  covariates = NULL,
  sample.id = NULL,
  response = "mixed",
  sample.specific = c("shares", "probs", "trembles"),
  r.probs = "no",
  r.trembles = "global",
  select = NULL,
  min.strategies = 1,
  crit = "bic",
  se = "analytic",
  outer.runs = 1,
  outer.tol = 1e-10,
  outer.max = 1000,
  inner.runs = 10,
  inner.tol = 1e-05,
  inner.max = 10,
  lcr.runs = 100,
  lcr.tol = 1e-10,
  lcr.max = 1000,
  bs.samples = 1000,
  quantiles = c(0.05, 0.5, 0.95),
  step.size = 1,
  penalty = F,
  verbose = FALSE
)
}
\arguments{
\item{data}{a \code{stratEst.data} object or \code{data.frame}.}

\item{strategies}{a list of strategies. Each element if the list must be an object of class \code{stratEst.strategy}.}

\item{shares}{a numeric vector of strategy shares. The order of the elements corresponds to the order in \code{strategies}. Elements which are \code{NA} are estimated from the data. Use a list of numeric vectors if data has more than one sample and shares are sample specific.}

\item{coefficients}{a matrix of latent class regression coefficients.}

\item{covariates}{a character vector with the names of the covariates of the latent class regression model in the data. The covariates cannot have missing values.}

\item{sample.id}{a character string indicating the name of the variable which identifies the samples in data. Individual observations must be nested in samples.}

\item{response}{a character string which is either \code{"pure"} or \code{"mixed"}. If \code{"pure"} the estimated choice probabilities are either zero or one. If \code{"mixed"} the estimated choice probabilities are mixed parameters. The default is \code{"mixed"}.}

\item{sample.specific}{a character vector, Defines the model parameters that are sample specific. Can contain the character strings \code{"shares"} (\code{"probs"},  \code{"trembles"}. If the vector contains \code{"shares"} (\code{"probs"}, \code{"trembles"}), the estimation function estimates a set of shares (choice probabilities, trembles) for each sample in the data.}

\item{r.probs}{a character string. Options are \code{"no"}, \code{"strategies"}, \code{"states"} or \code{"global"}. Option \code{"no"} yields one vector of choice probabilities per strategy and state. Option \code{"strategies"} yields one vector of choice probabilities per strategy. Option \code{"states"} yields one vector of choice probabilities per state. Option \code{"global"} yields a single vector of choice probabilities. Default is \code{"no"}.}

\item{r.trembles}{a character string. Options are \code{"no"}, \code{"strategies"}, \code{"states"} or \code{"global"}. Option \code{"no"} yields one tremble probability per strategy and state. Option \code{"strategies"} yields one tremble probability per strategy. Option \code{"states"} yields one tremble probability per state. Option \code{"global"} yields a single tremble probability. Default is \code{"no"}.}

\item{select}{a character vector. Indicates the classes of model parameters that are selected. Can contain the character strings \code{"strategies"}, (\code{"probs"}, and \code{"trembles"}.  If the vector contains\code{"strategies"} (\code{"probs"}, \code{"trembles"}), the number of strategies (choice probabilities, trembles) is selected based on the selection criterion specified in \code{"crit"}. The selection can be restricted with the arguments \code{r.probs} and \code{r.trembles}. Default is \code{NULL}.}

\item{min.strategies}{an integer. The minimum number of strategies in case of strategy selection. The strategy selection procedure stops if the minimum is reached.}

\item{crit}{a character string. Defines the information criterion used for model selection. Options are \code{"bic"} (Bayesian information criterion), \code{"aic"} (Akaike information criterion) or \code{"icl"} (Integrated Classification Likelihood). Default is \code{"bic"}.}

\item{se}{a string. Defines how standard errors are obtained. Options are \code{"analytic"} or \code{"bootstrap"}. Default is \code{"analytic"}.}

\item{outer.runs}{an integer. The number of outer runs of the solver. Default is 1.}

\item{outer.tol}{a number close to zero. The tolerance of the stopping condition of the outer runs. The iterative algorithm stops if the relative decrease of the log likelihood is smaller than this number. Default is 1e-10.}

\item{outer.max}{an integer. The maximum number of iterations of the outer runs of the solver. The iterative algorithm stops after \code{"outer.max"} iterations if it does not converge. Default is 1000.}

\item{inner.runs}{an integer. The number of inner runs of the solver. Default is 10.}

\item{inner.tol}{a number close to zero. The tolerance of the stopping condition of the inner runs. The iterative algorithm stops if the relative decrease of the log likelihood is smaller than this number. Default is 1e-5.}

\item{inner.max}{an integer. The maximum number of iterations of the outer runs of the solver. The iterative algorithm stops after \code{"inner.max"} iterations if it does not converge. Default is 10.}

\item{lcr.runs}{an integer. The number of latent class regression runs of the solver. Default is 100.}

\item{lcr.tol}{a number close to zero. The tolerance of the stopping condition of the latent class regression runs. The iterative algorithm stops if the relative decrease of the log likelihood is smaller than this number. Default is 1e-10.}

\item{lcr.max}{an integer. The maximum number of iterations of the latent class regression runs of the solver. The iterative algorithm stops after \code{"lcr.max"} iterations if it does not converge. Default is 1000.}

\item{bs.samples}{an integer. The number of bootstrap samples.}

\item{quantiles}{a numeric vector. The quantiles of the sampling distribution of the estimated parameters. Depending on the option of \code{se}, the quantiles are either estimated based on a t-distribution with \code{res.degrees} of freedom and the analytic standard errors or based the bootstrap.}

\item{step.size}{a number between zero and one. The step size of the Fisher scoring step which updates the coefficients. Values smaller than one slow down the convergence of the algorithm and prevent overshooting. Default is one.}

\item{penalty}{a logical. If \code{TRUE} the Firth penalty is used to estimate the coefficients of the latent class regression model. Default is \code{FALSE}.}

\item{verbose}{a logical. If \code{TRUE} information about the estimation process are printed to the console. Default is \code{FALSE}.}
}
\value{
An object of class \code{stratEst.model}. A list with the following elements.
\item{strategies}{the fitted strategies.}
\item{shares}{the strategy shares.}
\item{probs}{the choice probabilities of the strategies.}
\item{trembles}{the tremble probabilities of the strategies.}
\item{gammas}{the gamma parameters of the strategies.}
\item{coefficients}{ the coefficients of the covariates.}
\item{shares.par}{the estimated strategy share parameters.}
\item{probs.par}{the estimated choice probability parameters.}
\item{trembles.par}{the estimated tremble parameters.}
\item{gammas.par}{the estimated gamma parameters.}
\item{coefficients.par}{the estimated coefficient parameters of the covariates.}
\item{shares.indices}{the parameter indices of the strategy shares.}
\item{probs.indices}{the parameter indices of the choice probabilities.}
\item{trembles.indices}{the parameter indices of the tremble probabilities.}
\item{coefficients.indices}{the parameter indices of the coefficients.}
\item{loglike}{the log likelihood of the model.}
\item{num.ids}{the number of individuals.}
\item{num.obs}{the number of observations.}
\item{num.par}{the total number of model parameters.}
\item{free.par}{the number of free model parameters.}
\item{res.degrees}{the residual degrees of freedom.}
\item{aic}{the Akaike information criterion.}
\item{bic}{the Bayesian information criterion.}
\item{icl}{The integrated classification likelihood.}
\item{crit.val}{the value of the selection criterion defined by the argument \code{crit}.}
\item{eval}{the total number of iterations of the solver.}
\item{tol.val}{the relative decrease of the log likelihood in the last iteration of the algorithm.}
\item{convergence}{the maximum of the absolute scores of the estimated model parameters.}
\item{entropy.model}{the entropy of the model.}
\item{entropy.assignments}{the entropy of the posterior probability assignments of individuals to strategies.}
\item{chi.global}{the chi square statistic for global model fit.}
\item{chi.local}{the chi square statistics for local model fit.}
\item{state.obs}{the weighted observations for each strategy state.}
\item{post.assignments}{the posterior probability assignments of individuals to strategies.}
\item{prior.assignments}{the prior probability of each individual to use a strategy as predicted by the individual covariates.}
\item{shares.se}{the standard errors of the estimated share parameters.}
\item{probs.se}{the standard errors of the estimated choice probability parameters.}
\item{trembles.se}{the standard errors of the estimated tremble probability parameters.}
\item{gammas.se}{the standard errors of the estimated gamma parameters.}
\item{coefficients.se}{the standard errors of the estimated coefficients.}
\item{shares.quantiles}{the quantiles of the estimated population shares.}
\item{probs.quantiles}{the quantiles of the estimated choice probabilities.}
\item{trembles.quantiles}{the quantiles of the estimated trembles.}
\item{coefficients.quantiles}{the quantiles of the estimated coefficients.}
\item{shares.score}{the scores of the estimated share parameters.}
\item{probs.score}{the score of the estimated choice probabilities.}
\item{trembles.score}{the score of the estimated tremble probabilities.}
\item{coefficients.score}{the score of the estimated coefficient.}
\item{shares.fisher}{the Fisher information matrix of the estimated shares.}
\item{probs.fisher}{the Fisher information matrix of the estimated choice probabilities.}
\item{trembles.fisher}{the Fisher information matrix of the estimated trembles.}
\item{coefficients.fisher}{the fisher information matrix of the estimated coefficients.}
\item{fit.args}{the input objects of the function call.}
}
\description{
The estimation function of the package.
}
\details{
The estimation function of the package obtains maximum likelihood estimates for the model parameters based on expectation maximization and Newton-Raphson algorithms.
}
\note{
Strategy estimation was introduced by Dal Bo and Frechette (2011) to estimate the maximum likelihood frequencies of a set of candidate strategies in the repeated prisoner's dilemma. Breitmoser (2015) introduces model parameters for the choice probabilities of individual strategies to the strategy estimation model. Dvorak and Fehrler (2018) extend the basic strategy estimation model by individual level covariates to explain the selection of strategies by individuals. The estimation function of the package obtains maximum likelihood estimates for the model parameters based on expectation maximization (Dempster, Laird, and Rubin, 1977) and Newton-Raphson algorithms. To decrease the computation time, the package integrates \proglang{C++} and \proglang{R} with the help of the \proglang{R} packages \pkg{Rcpp} (Eddelbuettel and Francois, 2011) and the open source linear algebra library for the C++ language \pkg{RppArmadillo} (Sanderson and Curtin, 2016).
}
\examples{
## Strategy model for rock-paper-scissors data of Wang, Xu, and Zhou (2014).
## Fit a mixture of the Nash strategy and a strategy that imitates the last choice.
strategies.mixture = list("nash" = strategies.RPS$nash, "imitate" = strategies.RPS$imitate)
model.mixture <- stratEst.model(data.WXZ2014,strategies.mixture)

## Replication of Dal Bo and Frechette (2011), Table 7, page 424
model.DF2011 <- stratEst.model(data.DF2011, strategies.DF2011, sample.id = "treatment")

## Replication of Dvorak, Fischbacher, and Schmelz (2020)
covs <- c("intercept", "conformity.score")
model.DFS2020 <- stratEst.model(data.DFS2020, strategies.DFS2020, covariates = covs)

}
\references{
Breitmoser Y (2015). "Cooperation, but no Reciprocity: Individual Strategies in the Repeated Prisoner’s Dilemma." \emph{American Economic Review}, 105(9), 2882-2910.

Dal Bo P, Frechette GR (2011). "The Evolution of Cooperation in Infinitely Repeated Games: Experimental Evidence." \emph{American Economic Review}, 101(1), 411-429.

Dempster A, Laird N, Rubin DB (1977). "Maximum Likelihood from Incomplete Data via the EM Algorithm." \emph{Journal of the Royal Statistical Society Series B}, 39(1), 1-38.

Dvorak F, Fehrler S (2018). "Negotiating Cooperation under Uncertainty: Communication in Noisy, Indefinitely Repeated Interactions." \emph{IZA Working Paper}, No. 11897.

Dvorak F, Fischbacher U, Schmelz K (2020). "Incentives for Conformity and Anticonformity." \emph{TWI Working Paper Series}.

Eddelbuettel D, Francois R (2011). "Rcpp: Seamless R and C++ Integration." \emph{Journal of Statistical Software}, 40(8), 1-18.

Fudenberg D, Rand DG, Dreber A (2012). "Slow to Anger and Fast to Forgive: Cooperation in an Uncertain World." \emph{American Economic Review}, 102(2), 720-749.

Sanderson C, Curtin R (2016). "Armadillo: A Template-Based C++ Library for Linear Algebra." \emph{Journal of Open Source Software}, 1, 26.

Wang Z, Xu B, Zhou HJ (2014). "Social Cycling and Conditional Responses in the Rock-Paper-Scissors Game." \emph{Scientific Reports}, 4(1), 2045-2322.
}
