% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{Simulation}
\alias{Simulation}
\title{Simulation class}
\description{
Class for running a simulation and getting results.
}
\details{
The \code{Simulation} class is used to set up and run a daily
  simulation over a particular period. Portfolio construction parameters and
  other simulator settings can be configured in a yaml file that is passed to
  the object's constructor. See \code{vignette("strand")} for information on
  configuration file setup.
}
\examples{

# Load up sample data
data(sample_secref)
data(sample_pricing)
data(sample_inputs)

# Load sample configuration file
config_file <- system.file("application/strategy_config_obj.yaml", package = "strand")

# Create the Simulation object and run
sim <- Simulation$new(config_file,
                      raw_input_data = sample_inputs,
                      raw_pricing_data = sample_pricing,
                      security_reference_data = sample_secref)
sim$run()

# Print overall statistics
sim$overallStatsDf()

# Access tabular result data
head(sim$getSimSummary())
head(sim$getSimDetail())
head(sim$getPositionSummary())
head(sim$getInputStats())
head(sim$getOptimizationSummary())
head(sim$getExposures())

# Plot results
\dontrun{
sim$plotPerformance()
sim$plotMarketValue()
sim$plotCategoryExposure("category_1") 
sim$plotFactorExposure(c("factor_1", "factor_2", "factor_3"))
sim$plotNumPositions()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Simulation$new()}}
\item \href{#method-setVerbose}{\code{Simulation$setVerbose()}}
\item \href{#method-setShinyCallback}{\code{Simulation$setShinyCallback()}}
\item \href{#method-getSecurityReference}{\code{Simulation$getSecurityReference()}}
\item \href{#method-run}{\code{Simulation$run()}}
\item \href{#method-getSimDates}{\code{Simulation$getSimDates()}}
\item \href{#method-getSimSummary}{\code{Simulation$getSimSummary()}}
\item \href{#method-getSimDetail}{\code{Simulation$getSimDetail()}}
\item \href{#method-getPositionSummary}{\code{Simulation$getPositionSummary()}}
\item \href{#method-getInputStats}{\code{Simulation$getInputStats()}}
\item \href{#method-getLooseningInfo}{\code{Simulation$getLooseningInfo()}}
\item \href{#method-getOptimizationSummary}{\code{Simulation$getOptimizationSummary()}}
\item \href{#method-getExposures}{\code{Simulation$getExposures()}}
\item \href{#method-getDelistings}{\code{Simulation$getDelistings()}}
\item \href{#method-getSingleStrategySummaryDf}{\code{Simulation$getSingleStrategySummaryDf()}}
\item \href{#method-plotPerformance}{\code{Simulation$plotPerformance()}}
\item \href{#method-plotMarketValue}{\code{Simulation$plotMarketValue()}}
\item \href{#method-plotCategoryExposure}{\code{Simulation$plotCategoryExposure()}}
\item \href{#method-plotFactorExposure}{\code{Simulation$plotFactorExposure()}}
\item \href{#method-plotNumPositions}{\code{Simulation$plotNumPositions()}}
\item \href{#method-overallStatsDf}{\code{Simulation$overallStatsDf()}}
\item \href{#method-print}{\code{Simulation$print()}}
\item \href{#method-writeFeather}{\code{Simulation$writeFeather()}}
\item \href{#method-readFeather}{\code{Simulation$readFeather()}}
\item \href{#method-clone}{\code{Simulation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Simulation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$new(
  config,
  raw_input_data = NULL,
  raw_pricing_data = NULL,
  security_reference_data = NULL,
  delisting_dates_data = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{An object of class \code{list} or \code{character}. If the
value passed is a character vector, it should be of length 1 and
specify the path to a yaml configuration file that contains the
object's configuration info. If the value passed is of class list(),
the list should contain the object's configuration info in list form
(e.g, the return value of calling \code{yaml.load_file} on the
configuration file).}

\item{\code{raw_input_data}}{A data frame that contains all of the input data
(for all periods) for the simulation. The data frame must have a
\code{date} column. If \code{NULL}, input data will taken from daily
files specified in \code{config}. Defaults to \code{NULL}.}

\item{\code{raw_pricing_data}}{A data frame that contains all of the input data
(for all periods) for the simulation. The data frame must have a
\code{date} column. If \code{NULL}, pricing data will taken from daily
files specified in \code{config}. Defaults to \code{NULL}.}

\item{\code{security_reference_data}}{A data frame that contains reference data
on the securities in the simulation, including any categories that are
used in portfolio construction constraints. Note that the simulator
will throw an error if there are input data records for which there is
no entry in the security reference.}

\item{\code{delisting_dates_data}}{A data frame that contains the dates on which
securities are delisted. It must contain two columns: id (character)
and delisting_date (Date). The date in the delisting_date column means
the day on which a stock will be removed from the simulation portfolio,
at the beginning of the day, due to delisting. If \code{NULL},
delisting data will taken from a file specified in \code{config}.
Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Simulation} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setVerbose"></a>}}
\if{latex}{\out{\hypertarget{method-setVerbose}{}}}
\subsection{Method \code{setVerbose()}}{
Set the verbose flag to control info output.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$setVerbose(verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Logical flag indicating whether to be verbose or not.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setShinyCallback"></a>}}
\if{latex}{\out{\hypertarget{method-setShinyCallback}{}}}
\subsection{Method \code{setShinyCallback()}}{
Set the callback function for updating progress when running
  a simulation in shiny.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$setShinyCallback(callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback}}{A function suitable for updating a shiny Progress object.
It must have two parameters: \code{value}, indicating the progress
amount, and detail, and \code{detail}, a text string for display on the
progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSecurityReference"></a>}}
\if{latex}{\out{\hypertarget{method-getSecurityReference}{}}}
\subsection{Method \code{getSecurityReference()}}{
Get security reference information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getSecurityReference()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains the security
  reference data for the simulation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
Run the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$run()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value, called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSimDates"></a>}}
\if{latex}{\out{\hypertarget{method-getSimDates}{}}}
\subsection{Method \code{getSimDates()}}{
Get a list of all date for the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getSimDates()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of class \code{Date} over which the simulation currently iterates: all
weekdays between the 'from' and 'to' dates in the simulation's config.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSimSummary"></a>}}
\if{latex}{\out{\hypertarget{method-getSimSummary}{}}}
\subsection{Method \code{getSimSummary()}}{
Get summary information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getSimSummary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains summary data
  for the simulation, by period, at the joint and strategy level. The data
  frame contains the following columns:
  \describe{
    \item{strategy}{Strategy name, or 'joint' for the aggregate strategy.}
    \item{sim_date}{Date of the summary data.}
    \item{market_fill_nmv}{Total net market value of fills that do not
    net down across strategies.}
    \item{transfer_fill_nmv}{Total net market value of fills that
    represent "internal transfers", i.e., fills in one strategy that net
    down with fills in another. Note that at the joint level this column
    by definition is 0.}
    \item{market_order_gmv}{Total gross market value of orders that do not
    net down across strategies.}
    \item{market_fill_gmv}{Total gross market value of fills that do not
    net down across strategies.}
    \item{transfer_fill_gmv}{Total gross market value of fills that
    represent "internal transfers", i.e., fills in one strategy that net
    down with fills in another.}
    \item{start_nmv}{Total net market value of all positions at the start
    of the period.}
    \item{start_lmv}{Total net market value of all long positions at the
    start of the period.}
    \item{start_smv}{Total net market value of all short positions at the
    start of the period.}
    \item{end_nmv}{Total net market value of all positions at the end of
    the period.}
    \item{end_gmv}{Total gross market value of all positions at the end
    of the period.}
    \item{end_lmv}{Total net market value of all long positions at the
    end of the period.}
    \item{end_smv}{Total net market value of all short positions at the
    end of the period.}
    \item{end_num}{Total number of positions at the end of the period.}
    \item{end_num_long}{Total number of long positions at the end of the
    period.}
    \item{end_num_short}{Total number of short positions at the end of
    the period.}
    \item{position_pnl}{The total difference between the end and start
    market value of positions.}
    \item{trading_pnl}{The total difference between the market value of
    trades at the benchmark price and at the end price. Note: currently
    assuming benchmark price is the closing price, so trading P&L is
    zero.}
    \item{gross_pnl}{Total P&L gross of costs, calculated as position_pnl
    + trading_pnl.}
    \item{trade_costs}{Total trade costs (slippage).}
    \item{financing_costs}{Total financing/borrow costs.}
    \item{net_pnl}{Total P&L net of costs, calculated as gross_pnl -
    trade_costs - financing_costs.}
    \item{fill_rate_pct}{Total fill rate across all market orders,
    calculated as 100 * market_fill_gmv / market_order_gmv.}
    
  }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSimDetail"></a>}}
\if{latex}{\out{\hypertarget{method-getSimDetail}{}}}
\subsection{Method \code{getSimDetail()}}{
Get detail information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getSimDetail(
  sim_date = NULL,
  strategy_name = NULL,
  security_id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sim_date}}{Vector of length 1 of class Date or character that
specifies the period for which to get detail information. If
\code{NULL} then data from all periods is returned. Defaults
to \code{NULL}.}

\item{\code{strategy_name}}{Character vector of length 1 that specifies the
strategy for which to get detail data. If \code{NULL} data for all
strategies is returned. Defaults to \code{NULL}.}

\item{\code{security_id}}{Character vector of length 1 that specifies the
security for which to get detail data. If \code{NULL} data for all
securities is returned. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{data.frame} that contains detail data
  for the simulation at the joint and strategy level. Detail data is at
  the security level. The data frame contains the following columns:
  \describe{
    \item{id}{Security identifier.}
    \item{strategy}{Strategy name, or 'joint' for the aggregate strategy.}
    \item{sim_date}{Date to which the data pertains.}
    \item{shares}{Shares at the start of the period.}
    \item{int_shares}{Shares at the start of the period that net down
    with positions in other strategies.}
    \item{ext_shares}{Shares at the start of the period that do not net
    down with positions in other strategies.}
    \item{order_shares}{Order, in shares.}
    \item{market_order_shares}{Order that does not net down with orders
    in other strategies, in shares.}
    \item{transfer_order_shares}{Order that nets down with orders in
    other strategies, in shares.}
    \item{fill_shares}{Fill, in shares.}
    \item{market_fill_shares}{Fill that does not net down with fills in
    other strategies, in shares.}
    \item{transfer_fill_shares}{Fill that nets down with fills in other
    strategies, in shares.}
    \item{end_shares}{Shares at the end of the period.}
    \item{end_int_shares}{Shares at the end of the period that net down
    with positions in other strategies.}
    \item{end_ext_shares}{Shares at the end of the period that do not net
    down with positions in other strategies.}
    \item{start_price}{Price for the security at the beginning of the
    period.}
    \item{end_price}{Price for the security at the end of the period.}
    \item{dividend}{Dividend for the security, if any, for the
    period.}
    \item{distribution}{Distribution (e.g., spin-off) for the security, if
    any, for the period.}
    \item{position_pnl}{Position P&L, calculated as shares * (end_price +
    dividend + distribution - start_price)}
    \item{trading_pnl}{The difference between the market value of
    trades at the benchmark price and at the end price. Note: currently
    assuming benchmark price is the closing price, so trading P&L is
    zero.}
    \item{trade_costs}{Trade costs, calculated as a fixed percentage (set
    in the simulation configuration) of the notional of the market trade
    (valued at the close).}
    \item{financing_costs}{Financing cost for the position, calculated as
    a fixed percentage (set in the simulation configuration) of the
    notional of the starting value of the portfolio's external positions.
    External positions are positions held on the street and are recorded
    in the ext_shares column.}
    \item{gross_pnl}{Gross P&L, calculated as position_pnl + trading_pnl.}
    \item{net_pnl}{Net P&L, calculated as gross_pnl - trade_costs -
    financing_costs.}
    \item{market_order_nmv}{Net market value of the order that does not
    net down with orders in other strategies.}
    \item{market_fill_gmv}{Gross market value of the order that does not
    net down with orders in other strategies.}
    \item{market_fill_nmv}{Net market value of the fill that does not net
    down with orders in other strategies.}
    \item{market_fill_gmv}{Gross market value of the fill that does not
    net down with orders in other strategies.}
    \item{transfer_fill_nmv}{Net market value of the fill that nets down
    with fills in other strategies.}
    \item{transfer_fill_gmv}{Gross market value of the fill that nets down
    with fills in other strategies.}
    \item{start_nmv}{Net market value of the position at the start of the
    period.}
    \item{end_nmv}{Net market value of the position at the end of the
    period.}
    \item{end_gmv}{Gross market value of the position at the end of the
    period.}
  }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPositionSummary"></a>}}
\if{latex}{\out{\hypertarget{method-getPositionSummary}{}}}
\subsection{Method \code{getPositionSummary()}}{
Get summary information by security. This method can be
  used, for example, to calculate the biggest winners and losers over the
  course of the simulation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getPositionSummary(strategy_name = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{strategy_name}}{Character vector of length 1 that specifies the
strategy for which to get detail data. If \code{NULL} data for all
strategies is returned. Defaults to \code{NULL}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{data.frame} that contains summary
  information aggregated by security. The data frame contains the
  following columns:
  \describe{
    \item{id}{Security identifier.}
    \item{strategy}{Strategy name, or 'joint' for the aggregate
    strategy.}
    \item{gross_pnl}{Gross P&L for the position over the entire
    simulation.}
    \item{gross_pnl}{Net P&L for the position over the entire
    simulation.}
    \item{average_market_value}{Average net market value of the
    position over days in the simulation where the position was not
    flat.}
    \item{total_trading}{Total gross market value of trades for the
    security.}
    \item{trade_costs}{Total cost of trades for the security over the
    entire simulation.}
    \item{trade_costs}{Total cost of financing for the position over the
    entire simulation.}
    \item{days_in_portfolio}{Total number of days there was a position in
    the security in the portfolio over the entire simulation.}
  }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getInputStats"></a>}}
\if{latex}{\out{\hypertarget{method-getInputStats}{}}}
\subsection{Method \code{getInputStats()}}{
Get input statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getInputStats()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains statistics on
  select columns of input data. Statistics are tracked for the columns
  listed in the configuration variable
  \code{simulator/input_data/track_metadata}. The data frame contains the
  following columns:
  \describe{
    \item{period}{Period to which statistics pertain.}
    \item{input_rows}{Total number of rows of input data, including
    rows carried forward from the previous period.}
    \item{cf_rows}{Total number of rows carried forward from the previous
    period.}
    \item{num_na_\emph{column}}{Number of NA values in \emph{column}.  This
    measure appears for each element of \code{track_metadata}.}
    \item{cor_\emph{column}}{Period-over-period correlation for \emph{column}.
    This measure appears for each element of \code{track_metadata}.}
 }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getLooseningInfo"></a>}}
\if{latex}{\out{\hypertarget{method-getLooseningInfo}{}}}
\subsection{Method \code{getLooseningInfo()}}{
Get loosening information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getLooseningInfo()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains, for each
  period, which constraints were loosened in order to solve the portfolio
  optimization problem, if any. The data frame contains the
  following columns:
  \describe{
    \item{date}{Date for which the constraint was loosened.}
    \item{constraint_name}{Name of the constraint that was loosened.}
    \item{pct_loosened}{Percentage by which the constraint was loosened,
    where 100 means loosened fully (i.e., the constraint is effectively
    removed).}
  }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getOptimizationSummary"></a>}}
\if{latex}{\out{\hypertarget{method-getOptimizationSummary}{}}}
\subsection{Method \code{getOptimizationSummary()}}{
Get optimization summary information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getOptimizationSummary()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains optimization
  summary information, such as starting and ending factor constraint
  values, at the strategy and joint level. The data frame contains the
  following columns:
  \describe{
    \item{strategy}{Strategy name, or 'joint' for the aggregate strategy.}
    \item{sim_date}{Date to which the data pertains.}
    \item{order_gmv}{Total gross market value of orders generated by the
    optimization.}
    \item{start_smv}{Total net market value of short positions at the
    start of the optimization.}
    \item{start_lmv}{Total net market value of long positions at the
    start of the optimization.}
    \item{end_smv}{Total net market value of short positions at the end
    of the optimization.}
    \item{end_lmv}{Total net market value of long positions at the end of
    the optimization.}
    \item{start_\emph{factor}}{Total net exposure to \emph{factor} at the
    start of the optimization, for each factor constraint.}
    \item{end_\emph{factor}}{Total net exposure to \emph{factor} at the
    start of the optimization, for each factor constraint.}
  }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getExposures"></a>}}
\if{latex}{\out{\hypertarget{method-getExposures}{}}}
\subsection{Method \code{getExposures()}}{
Get end-of-period exposure information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getExposures()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains end-of-period
  exposure information for the simulation portfolio. The units of the
  exposures are portfolio weight relative to strategy_captial (i.e., net
  market value of exposure divided by strategy capital). The data frame
  contains the following columns:
  \describe{
    \item{strategy}{Strategy name, or 'joint' for the aggregate strategy.}
    \item{sim_date}{Date of the exposure data.}
    \item{\emph{category}_\emph{level}}{Exposure to \emph{level}
    within \emph{category}, for all levels of all category constraints, at the end
    of the period.}
    \item{\emph{factor}}{Exposure to \emph{factor}, for all factor
    constraints, at the end of the period.}
  }
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDelistings"></a>}}
\if{latex}{\out{\hypertarget{method-getDelistings}{}}}
\subsection{Method \code{getDelistings()}}{
Get information on positions removed due to delisting.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getDelistings()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An object of class \code{data.frame} that contains a row for each
  position that is removed from the simulation portfolio due to a
  delisting. Each row contains the size of the position on the day on
  which it was removed from the portfolio.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSingleStrategySummaryDf"></a>}}
\if{latex}{\out{\hypertarget{method-getSingleStrategySummaryDf}{}}}
\subsection{Method \code{getSingleStrategySummaryDf()}}{
Get summary information for a single strategy suitable for
  plotting input.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$getSingleStrategySummaryDf(strategy_name, include_zero_row = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{strategy_name}}{Strategy for which to return summary data.}

\item{\code{include_zero_row}}{Logical flag indicatiing whether to prepend a row
to the summary data with starting values at zero. Defaults to \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame that contains summary information for the desired
  strategy, as well as columns for cumulative net and gross total return,
  calculated as pnl divided by ending gross market value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotPerformance"></a>}}
\if{latex}{\out{\hypertarget{method-plotPerformance}{}}}
\subsection{Method \code{plotPerformance()}}{
Draw a plot of cumulative gross and net return by date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$plotPerformance()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotMarketValue"></a>}}
\if{latex}{\out{\hypertarget{method-plotMarketValue}{}}}
\subsection{Method \code{plotMarketValue()}}{
Draw a plot of total gross, long, short, and net market value by date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$plotMarketValue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotCategoryExposure"></a>}}
\if{latex}{\out{\hypertarget{method-plotCategoryExposure}{}}}
\subsection{Method \code{plotCategoryExposure()}}{
Draw a plot of exposure to all levels in a category by date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$plotCategoryExposure(in_var)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_var}}{Category for which exposures are plotted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotFactorExposure"></a>}}
\if{latex}{\out{\hypertarget{method-plotFactorExposure}{}}}
\subsection{Method \code{plotFactorExposure()}}{
Draw a plot of exposure to factors by date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$plotFactorExposure(in_var)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_var}}{Factors for which exposures are plotted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plotNumPositions"></a>}}
\if{latex}{\out{\hypertarget{method-plotNumPositions}{}}}
\subsection{Method \code{plotNumPositions()}}{
Draw a plot of number of long and short positions by date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$plotNumPositions()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-overallStatsDf"></a>}}
\if{latex}{\out{\hypertarget{method-overallStatsDf}{}}}
\subsection{Method \code{overallStatsDf()}}{
Calculate overall simulation summary statistics, such as
  total P&L, Sharpe, average market values and counts, etc.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$overallStatsDf()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame that contains summary statistics, suitable for
  reporting.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print overall simulation statistics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-writeFeather"></a>}}
\if{latex}{\out{\hypertarget{method-writeFeather}{}}}
\subsection{Method \code{writeFeather()}}{
Write the data in the object to feather files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$writeFeather(out_loc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{out_loc}}{Directory in which output files should be created.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-readFeather"></a>}}
\if{latex}{\out{\hypertarget{method-readFeather}{}}}
\subsection{Method \code{readFeather()}}{
Load files created with \code{writeFeather} into the object.
  Note that because detail data is not re-split by period, it will not be
  possible to use the \code{sim_date} parameter when calling
  \code{getSimDetail} on the populated object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$readFeather(in_loc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{in_loc}}{Directory that contains files to be loaded.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value, called for side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Simulation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
