% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{stack2}
\alias{stack2}
\title{Stack one Set of Variables from Wide to Long}
\usage{
stack2(
  data,
  select.nm,
  keep.nm = pick(x = names(data), val = select.nm, not = TRUE),
  rtn.el.nm = "el",
  rtn.vrbnames.nm = "vrb_names",
  rtn.rownames.nm = "row_names",
  order.by.rownames = TRUE,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{select.nm}{character vector of colnames from \code{data} specifying the
variables to be stacked.}

\item{keep.nm}{optional argument containing a character vector of colnames from
\code{data} specifying the additional columns to be included in the return object.
These columns are repeated down the data.frame as they are not stacked together.
The default is the inclusion of all other columns in \code{data} other than
\code{select.nm}. If NULL, then no other columns will be included.}

\item{rtn.el.nm}{character vector of length 1 specifying the name of the column
in the return object that corresponds to the elements of the stacked variables.}

\item{rtn.vrbnames.nm}{character vector of length 1 specifying the name of the column
in the return object that corresponds to the names of the stacked variables.}

\item{rtn.rownames.nm}{character vector of length 1 specifying the name of the column
in the return object that corresponds to the rownames.}

\item{order.by.rownames}{logical vector of length 1 specifying whether the returned
data.frame should be ordered by the positions of the rownames (TRUE) or by the
positions of the names of the stacked variables (i.e., \code{select.nm}). Note,
the ordering is by the *positions*, not by alphabetical order. If that is desired,
convert the rownames to a (id) column and use \code{reshape::melt.data.frame}.}

\item{stringsAsFactors}{logical vector of length 1 specifying whether the
\code{rtn.vrbnames.nm} and \code{rtn.rownames.nm} columns should be converted
to factors. Note, the factor levels are ordered by positions and not alphabetically
(see \code{v2fct}).}
}
\value{
data.frame with nrow = \code{nrow(data) * length(`select.nm`)} from stacking the
elements of \code{data[select.nm]} on top of one another. The first column is
the rownames with name \code{rtn.rownames.nm}, the second column is the names
of the stacked variables with name \code{rtn.vrbnames.nm}, the third column is
the stacked elements with name \code{rtn.el.nm}, and the additional columns
are those specified by \code{keep.nm}.
}
\description{
\code{stack2} converts one set of variables in a data.frame from wide to long format.
(If you want to convert *multiple* sets of variables from wide to long, see
\code{reshape}.) It is a modified version of \code{stack} that 1) adds a column for
the rownames, 2) returns character vectors rather than factors, 3) can return
additional (repeated) columns, and 4) can order by rownames original
positions rather than the variable names being stacked call order.
}
\details{
\code{stack2} is also very similar to \code{reshape::melt.data.frame}. The
differences are that it 1) adds a column for the rownames, 2) returns character
vectors rather than factors, and 3) can order by rownames original positions
rather than the variable names being stacked call order.
}
\examples{

# general
stack2(data = mtcars, select.nm = c("disp","hp","drat","wt","qsec"),
   keep.nm = c("vs","am"))
stack2(data = mtcars, select.nm = c("disp","hp","drat","wt","qsec"),
   keep.nm = c("vs","am"), rtn.el.nm = "rating", rtn.vrbnames.nm = "item",
   rtn.rownames.nm = "row_names") # change the return object colnames
stack2(data = mtcars, select.nm = c("disp","hp","drat","wt","qsec"),
   keep.nm = pick(x = names(mtcars), val = c("disp","hp","drat","wt","qsec"),
   not = TRUE)) # include all columns from `data` in the return object

# keep options
stack2(data = mtcars, select.nm = c("mpg","cyl","disp")
   ) # default = keep all other variables in `data`
stack2(data = mtcars, select.nm = c("mpg","cyl","disp"), keep = c("gear","carb")
   ) # character vector = keep only specified variables in `data`
stack2(data = mtcars, select.nm = c("mpg","cyl","disp"), keep = NULL,
   ) # NULL = keep no other variables in `data`

# compare to utils:::stack.data.frame and reshape::melt.data.frame
ChickWeight2 <- as.data.frame(datasets::ChickWeight)
ChickWeight2$"Diet" <- as.integer(ChickWeight2$"Diet")
x <- stack(x = ChickWeight2, select = c("weight","Diet")) # does not allow
   # keeping additional columns
y <- reshape::melt(data = ChickWeight2, measure.vars = c("weight","Diet"),
   id.nm = c("Chick","Time"), variable_name = "vrb_names") # does not include
   # rownames and not ordered by rownames
z <- stack2(data = ChickWeight2, select.nm = c("weight","Diet"),
   keep.nm = c("Chick","Time"))
head(x); head(y); head(z)
}
\seealso{
\code{\link{unstack2}}
   \code{\link{stack}}
   \code{\link[reshape]{melt.data.frame}}
}
