% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{d2a}
\alias{d2a}
\title{Data-Frame to (3D+) Array}
\usage{
d2a(d, el.nm = "element", check = TRUE)
}
\arguments{
\item{d}{data.frame with at least 4 columns, where 3+ columns are variable
dimensions and 1 column contains the to-be array elements. The columns containing
the variable dimensions do not need to be factors or character vectors.}

\item{el.nm}{character vector of length 1 specifying the colname in \code{d}
that contains the to-be array elements.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{d} is a data.frame.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
(3D+) array containing the elements in \code{d[[el.nm]]}. The dimlabels
are the colnames of \code{d} other than \code{el.nm} and the dimnames are the unique
elements in those columns. The dimnames are ordered by position (rather than
alphabetically), which allow for conversions back to the original array after
a call to \code{a2d()}.
}
\description{
\code{d2a} converts a data.frame to a (3D+) array. This function assumes the
data.frame contains 3+ variable dimensions, which will correspond to the
returned arrays dimensions. One variable (and one variable only) must contain
the elements which will correspond to the elements of the returned array.
}
\details{
\code{d2a} is a wrapper for \code{reshape::cast} with the addition of reordering
the dimnames by position, which sorts the dimnames by the position they first
appear in the variable dimensions of the data.frame (\code{reshape::cast}) sorts
all the dimnames alphabetically).
}
\examples{
print(HairEyeColor)
d <- reshape::melt.array(HairEyeColor)
a <- reshape::cast(d, Hair ~ Eye ~ Sex)
identical(a, unclass(HairEyeColor)) # not the same as HairEyeColor
d <- a2d(HairEyeColor)
a <- d2a(d)
identical(a, unclass(HairEyeColor)) # yes the same as HairEyeColor
}
