% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_midpoint}
\alias{line_midpoint}
\title{Find the mid-point of lines}
\usage{
line_midpoint(l, tolerance = NULL)
}
\arguments{
\item{l}{A spatial lines object}

\item{tolerance}{The tolerance used to break lines at verteces.
See \code{\link[lwgeom:st_linesubstring]{lwgeom::st_linesubstring()}}.}
}
\description{
Find the mid-point of lines
}
\examples{
l = routes_fast_sf[2:5, ]
plot(l$geometry, col = 2:5)
midpoints = line_midpoint(l)
plot(midpoints, add = TRUE)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_segment}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
