% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_projected.R
\name{geo_projected}
\alias{geo_projected}
\alias{gprojected}
\title{Perform GIS functions on a temporary, projected version of a spatial object}
\usage{
geo_projected(shp, fun, crs, silent, ...)
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}

\item{fun}{A function to perform on the projected object (e.g. the the rgeos or sf packages)}

\item{crs}{An optional coordinate reference system (if not provided it is set
automatically by \code{\link[=geo_select_aeq]{geo_select_aeq()}})}

\item{silent}{A binary value for printing the CRS details (default: TRUE)}

\item{...}{Arguments to pass to \code{fun}, e.g. \code{byid = TRUE} if the function is \code{rgeos::gLength()}}
}
\description{
This function performs operations on projected data.
}
\examples{
lib_versions <- sf::sf_extSoftVersion()
lib_versions
# fails on some systems (with early versions of PROJ)
if (lib_versions[3] >= "6.3.1") {
  shp <- routes_fast_sf[2:4, ]
  geo_projected(shp, sf::st_buffer, dist = 100)
}
}
