% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distance-decay-functions.R
\name{dd_logsqrt}
\alias{dd_logsqrt}
\title{log-linear-square-root distance decay}
\usage{
dd_logsqrt(x, a, b1, b2)
}
\arguments{
\item{x}{A positive vector representing distances (often in km)}

\item{a}{Positive number (usually between 0 and 1) representing
the intercept of the distance decay curve with the y axis, when x = 0.}

\item{b1}{Number representing the 'beta' distance decay parameter.
Higher values make the decay steeper.}

\item{b2}{Number representing the second 'beta' distance decay parameter.
Higher values make the decay steeper.

log-linear distance decay (Iacono et al., 2010) with an additional
square-root term to make the curve more flexible. The additional
term (b2 in the function below) describes the short-term response:
positive b2 values result in a unimodal distance decay
with a peak after x = 0;
negative b2 values lead to rapid decay in cycling under 2 km.}
}
\description{
log-linear-square-root distance decay
}
\examples{
x = seq(0, 50, 0.1)
plot(x, dd_logsqrt(x, a = 0.3, b1 = -0.2, b2 = -0.5), ylim = c(0, 0.5))
lines(x, dd_logsqrt(x, a = 0.3, b1 = -0.2, b2 = 0.5))
}
\references{
Iacono, M., Krizek, K. J. and El-Geneidy, A. (2010).
Measuring non-motorized accessibility: issues, alternatives, and execution. Journal of Transport Geography, 18(1).
}

