% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_rds.R
\name{storr_rds}
\alias{driver_rds}
\alias{storr_rds}
\title{rds object cache driver}
\usage{
storr_rds(path, compress = TRUE, mangle_key = NULL,
  default_namespace = "objects")

driver_rds(path, compress = TRUE, mangle_key = NULL)
}
\arguments{
\item{path}{Path for the store.  \code{tempdir()} is a good choice
for ephemeral storage, The \code{rappdirs} package (on CRAN)
might be nice for persistent application data.}

\item{compress}{Compress the generated file?  This saves a small
amount of space for a reasonable amount of time.}

\item{mangle_key}{Mangle keys?  If TRUE, then the key is encoded
using base64 before saving to the filesystem.  See Details.}

\item{default_namespace}{Default namespace (see
\code{\link{storr}}).}
}
\description{
Object cache driver that saves objects using R's native
serialised file format (see \code{\link{saveRDS}}) on the
filesystem.
}
\details{
The \code{mangle_key} argument will run each key that is created
through a "base 64" encoding.  This means that keys that include
symbols that are invalid on filesystems (e.g, "/", ":") will be
replaced by harmless characters.  The RFC 4648 dialect is used
where "-" and "_" are used for character 62 and 63 (this differs
from most R base64 encoders).  This mangling is designed to be
transparent to the user -- the storr will appear to store things
with unmangled keys but the names of the stored files will be
different.

Note that the \emph{namespace} is not mangled (at least not yet)
so needs to contain characters that are valid in a filename.

Because the actual file will be stored with mangled names it is
not safe to use the same path for a storr with and without
mangling.  So once an rds storr has been created its "mangledness"
is set.  Using \code{mangle_key=NULL} uses whatever mangledness
exists (or no mangledness if creating a new storr).
}
\examples{

# Create an rds storr in R's temporary directory:
st <- storr_rds(tempfile())

# Store some data (10 random numbers against the key "foo")
st$set("foo", runif(10))
st$list()

# And retrieve the data:
st$get("foo")

# Keys that are not valid filenames will cause issues.  This will
# cause an error:
\dontrun{
st$set("foo/bar", letters)
}

# The solution to this is to "mangle" the key names.  Storr can do
# this for you:
st2 <- storr_rds(tempfile(), mangle_key=TRUE)
st2$set("foo/bar", letters)
st2$list()
st2$get("foo/bar")

# Behind the scenes, storr is safely encoding the filenames with base64:
dir(file.path(st2$driver$path, "keys", "objects"))

# Clean up the two storrs:
st$destroy()
st2$destroy()
}

