% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortino.R
\name{sortino}
\alias{sortino}
\title{Sortino Ratio}
\usage{
sortino(gains = NULL, prices = NULL, rf = 0)
}
\arguments{
\item{gains}{Numeric matrix with 1 column of gains for each investment (can 
be a vector if there is only one).}

\item{prices}{Numeric matrix with 1 column of prices for each investment (can 
be a vector if there is only one).}

\item{rf}{Numeric value.}
}
\value{
Numeric value or vector.
}
\description{
Calculates Sortino ratio from vector of gains or prices. The formula is: 
\code{(mean(gains) - rf) / sd(gains[gains < 0])}, where \code{rf} is some 
risk-free rate of return.
}
\examples{
# Simulate daily gains over a 5-year period
set.seed(123)
stock.gains <- rnorm(252 * 5, 0.0005, 0.01)

# Calculate Sortino ratio using risk-free return of 0
sortino(stock.gains)


}
