\name{paratraceplot}
\alias{paratraceplot}
\title{
Trace Plot of MCMC Draws from the Parameter Posteriors
}
\description{
Displays a plot of iterations vs. sampled values the parameters \code{mu}, \code{phi} and \code{sigma}, with a separate plot per variable.
}
\usage{
paratraceplot(x, mar = c(1.9, 1.9, 1.9, 0.5), mgp = c(2, 0.6, 0), ...)
}
\arguments{
  \item{x}{
   \code{svdraws} object.
}
  \item{mar}{
   numerical vector of length 4, indicating the plot margins. See \code{\link[graphics]{par}} for details. The default value is \code{c(1.9, 1.9, 1.9, 0.5)}, which is slightly smaller than the R-defaults.
}
  \item{mgp}{
   numerical vector of length 3, indicating the axis and label positions. See \code{\link[graphics]{par}} for details. The default value is \code{c(2, 0.6, 0)}, which is slightly smaller than the R-defaults.
}
  \item{\dots}{
  further arguments are passed on to the invoked \code{matplot} function.
}
}

\details{
\code{paratraceplot} is modeled after \code{\link[coda]{traceplot}} in the \code{coda} package, with very minor modifications.
}

\value{
 Called for its side effects. Returns argument \code{x} invisibly.
}

\author{
Gregor Kastner \email{gregor.kastner@wu.ac.at}
}

\note{
 You can call this function directly, but it is more commonly called by the \code{\link{plot.svdraws}} method.
}

\seealso{
\code{\link{paradensplot}}, \code{\link{volplot}}, \code{\link{plot.svdraws}}
}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{hplot}
