% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_tree.r
\name{print_tree}
\alias{print_tree}
\title{Theme hierarchy tree view.}
\usage{
print_tree(mytheme, pruneMethod = c("simple", "dist"), limit = 100)
}
\arguments{
\item{mytheme}{A pkg{stoRy} package \code{theme} object.}

\item{pruneMethod}{default \code{c("simple", "dist")}. The 
\code{"Simple"} option is the default and prints up to \code{limit} 
themes as the appear in order in the tree. The \code{"dist"} option
prints the more upper level themes in the hierarchy.}

\item{limit}{The maximum number of themes to be printed. The default 
valuse is \code{100}.}
}
\value{
Given a \code{theme} object as input, \code{print_tree} prints 
a tree structure of its descendent themes.
}
\description{
\code{print_tree} Print a theme and its descendents in a 
tree format.
}
\examples{
########################################################################
# Display the "the human condition" theme hierarchy in tree format     #
########################################################################
theme_name <- "the human condition"
mytheme <- theme$new(theme_name)
print_tree(mytheme, pruneMethod = "dist", limit = 50)
}
