% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_results-class.R
\name{compare_emp}
\alias{compare_emp}
\title{Compare minimum expected populations}
\usage{
compare_emp(x, ..., interval = 95, all_points = FALSE, simulation_names = NULL)
}
\arguments{
\item{x}{a simulation_results object}

\item{...}{additional simulation results objects}

\item{interval}{the desired confidence interval representing the uncertainty around
the expected minimum population estimates from simulation comparisons; expressed as 
a whole integer between 0 and 100 (default value is 95).}

\item{all_points}{should the expected minimum populations from all simulation
replicates be shown on the plot?}

\item{simulation_names}{an optional character vector of simulation names to override
the defaults}
}
\description{
Compare minimum expected populations from two or more 'simulation_results' objects.
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

# Create populations dynamics with and without ceiling density dependence
pd1 <- population_dynamics(change = growth(egk_mat),
                           dispersal = kernel_dispersal(max_distance = 2000,
                           dispersal_kernel = exponential_dispersal_kernel(distance_decay = 1000)),
                           density_dependence = ceiling_density())
pd2 <- population_dynamics(change = growth(egk_mat),
                           dispersal = kernel_dispersal(max_distance = 2000,
                           dispersal_kernel = exponential_dispersal_kernel(distance_decay = 1000)))

# Run first simulation with ceiling density dependence and three replicates
sim1 <- simulation(landscape = ls,
                   population_dynamics = pd1,
                   habitat_dynamics = NULL,
                   timesteps = 20,
                   replicates = 3)
                   
# Run second simulation without ceiling density dependence and three replicates
sim2 <- simulation(landscape = ls,
                   population_dynamics = pd2,
                   habitat_dynamics = NULL,
                   timesteps = 20,
                   replicates = 3)

compare_emp(sim1, sim2)
}
}
