% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmod.R
\name{plotmod}
\alias{plotmod}
\title{Moderation Effect Plot}
\usage{
plotmod(
  output,
  x,
  w,
  x_label,
  w_label,
  y_label,
  title,
  digits = 3,
  x_from_mean_in_sd = 1,
  w_from_mean_in_sd = 1,
  w_method = c("sd", "percentile"),
  w_percentiles = c(0.16, 0.84),
  x_method = c("sd", "percentile"),
  x_percentiles = c(0.16, 0.84),
  w_sd_to_percentiles = NA,
  x_sd_to_percentiles = NA,
  note_standardized = TRUE,
  no_title = FALSE,
  line_width = 1,
  point_size = 5,
  graph_type = c("default", "tumble")
)
}
\arguments{
\item{output}{The output
of \code{\link[stats:lm]{stats::lm()}}, \code{\link[=std_selected]{std_selected()}}, or
\code{\link[=std_selected_boot]{std_selected_boot()}}.}

\item{x}{The name of the focal variable (x-axis) in `output``. It
can be the name of the variable, with or without quotes.
Currently only numeric variables are supported.}

\item{w}{The name of the moderator in \code{output}. It
can be the name of the variable, with or without quotes.}

\item{x_label}{The label for the X-axis. Default is the value of \code{x}.}

\item{w_label}{The label for the legend for the lines.
Default is the value of\code{w}.}

\item{y_label}{The label for the Y-axis. Default is the
name of the response variable in the model.}

\item{title}{The title of the graph. If not supplied, it will be
generated from the variable
names or labels (in \code{x_label}, \code{y_label},
and \code{w_label}). If \code{""}, no title will be printed.
This can be used when the plot is for manuscript
submission and figures are required to have no
titles.}

\item{digits}{Number of decimal places to print. Default is 3.}

\item{x_from_mean_in_sd}{How many SD from mean is used to define
"low" and
"high" for the focal variable.
Default is 1.}

\item{w_from_mean_in_sd}{How many SD from mean is used to define
"low" and
"high" for the moderator. Default is 1.
Ignored if \code{w} is categorical.}

\item{w_method}{How to define "high" and "low" for the moderator levels.
Default is in terms of the
standard deviation of the moderator, \code{"sd"}.
If equal to
\code{"percentile"}, then the percentiles of the moderator in
the
dataset are used.
Ignored if \code{w} is categorical.}

\item{w_percentiles}{If \code{w_method} is \code{"percentile"}, then this
argument
specifies the two percentiles to be used,
divided by 100.
It must be a
vector of two numbers. The default is
\code{c(.16, .84)},
the 16th and 84th percentiles,
which corresponds approximately
to one SD below and above mean for a
normal distribution, respectively.
Ignored if \code{w} is categorical.}

\item{x_method}{How to define "high" and "low" for the focal
variable levels.
Default is in terms of the
standard deviation of the focal variable, \code{"sd"}.
If equal to
\code{"percentile"}, then the percentiles of the
focal variable in the
dataset is used.}

\item{x_percentiles}{If \code{x_method} is \code{"percentile"}, then this
argument
specifies the two percentiles to be used,
divided by 100.
It must be a
vector of two numbers. The default is
\code{c(.16, .84)},
the 16th and 84th percentiles,
which corresponds approximately
to one SD below and above mean for a
normal distribution, respectively.}

\item{w_sd_to_percentiles}{If \code{w_method} is \code{"percentile"} and
this argument is
set to a number, this number will be
used
to determine the percentiles to be used.
The
lower percentile is the percentile in a
normal
distribution
that is \code{w_sd_to_percentiles} SD below
the mean.
The upper percentile is the percentile in
a normal
distribution that is \code{w_sd_to_percentiles}
SD
above the mean. Therefore, if
\code{w_sd_to_percentiles} is set to 1, then the
lower
and upper percentiles are 16th and 84th,
respectively. Default is \code{NA}.}

\item{x_sd_to_percentiles}{If \code{x_method} is \code{"percentile"} and this
argument is
set to a number, this number will be used
to determine the percentiles to be used. The
lower percentile is the percentile in a
normal
distribution
that is \code{x_sd_to_percentiles} SD below the mean.
The upper percentile is the percentile in a normal
distribution that is \code{x_sd_to_percentiles} SD
above the mean. Therefore, if
\code{x_sd_to_percentiles} is set to 1, then the lower
and upper percentiles are 16th and 84th,
respectively. Default is \code{NA}.}

\item{note_standardized}{If \code{TRUE}, will check whether a variable has SD
nearly equal to one. If yes, will report this in the
plot.
Default is \code{TRUE}.}

\item{no_title}{If \code{TRUE}, title will be suppressed. Default is \code{FALSE}.}

\item{line_width}{The width of the lines as used in
\code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}.
Default is 1.}

\item{point_size}{The size of the points as used in \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.
Default is 5.}

\item{graph_type}{If \code{"default"}, the typical line-graph with equal end-points
will be plotted. If \code{"tubmle"}, then the tumble graph
proposed by Bodner (2016) will be plotted. Default is
\code{"default"}.}
}
\value{
A \link{ggplot2} graph. Plotted if not assigned to a name. It can
be further modified like a usual \link{ggplot2} graph.
}
\description{
Plot the moderation effect in a regression model
}
\details{
This function generate a basic \link{ggplot2} graph
typically found in psychology manuscripts. It tries to
check whether one or more variables are standardized, and
report this in the plot if required.

This function only has features for typical plots of moderation effects.
It is not intended to be a flexible tool for a fine control on the plots.
}
\examples{

# Do a moderated regression by lm
lm_out <- lm(sleep_duration ~ age + gender + emotional_stability*conscientiousness, sleep_emo_con)
plotmod(lm_out,
        x = emotional_stability,
        w = conscientiousness,
        x_label = "Emotional Stability",
        w_label = "Conscientiousness",
        y_label = "Sleep Duration")

# Standardize all variables except for categorical variables
# Alternative: use to_standardize as a shortcut
# lm_std <- std_selected(lm_out,
#                        to_standardize = ~ .)
lm_std <- std_selected(lm_out,
                       to_scale = ~ .,
                       to_center = ~ .)
plotmod(lm_std,
        x = emotional_stability,
        w = conscientiousness,
        x_label = "Emotional Stability",
        w_label = "Conscientiousness",
        y_label = "Sleep Duration")

# Tumble Graph
plotmod(lm_std,
        x = emotional_stability,
        w = conscientiousness,
        x_label = "Emotional Stability",
        w_label = "Conscientiousness",
        y_label = "Sleep Duration",
        graph_type = "tumble")

}
\references{
Bodner, T. E. (2016). Tumble graphs: Avoiding misleading end point
extrapolation when graphing interactions from a moderated multiple
regression analysis. \emph{Journal of Educational and Behavioral
Statistics, 41}(6), 593-604. \doi{10.3102/1076998616657080}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
