% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_condeff.R
\name{confint.cond_effect}
\alias{confint.cond_effect}
\title{Confidence Intervals for a 'cond_effect' Class Object}
\usage{
\method{confint}{cond_effect}(object, parm, level = 0.95, type, ...)
}
\arguments{
\item{object}{The output of \code{\link[=cond_effect]{cond_effect()}} or \code{\link[=cond_effect_boot]{cond_effect_boot()}}.}

\item{parm}{Ignored by this function. The confidence intervals for all
available levels will be returned.}

\item{level}{The level of confidence. For the confidence intervals returned
by \code{\link[=lm]{lm()}}, default is .95, i.e., 95\%. For the bootstrap
percentile confidence
intervals, default is the level used in calling
\code{\link[=cond_effect_boot]{cond_effect_boot()}}.}

\item{type}{The type of the confidence intervals. If est to \code{"lm"},
returns the confidence interval given by the \code{\link[=confint]{confint()}} method
of \code{\link[=lm]{lm()}}.
If set to \code{"boot"}, the bootstrap percentile confidence intervals
are returned.
Default is \code{"boot"} if bootstrap estimates are stored in
\code{object}, and \code{"lm"} if bootstrap estimates are not stored.}

\item{...}{Additional arguments. Ignored.}
}
\value{
A matrix of the confidence intervals.
}
\description{
Return the confidence intervals of estimates
conditional effect in the output of
\code{\link[=cond_effect]{cond_effect()}} or \code{\link[=cond_effect_boot]{cond_effect_boot()}}.
}
\details{
If bootstrapping is used to form the confidence interval by
\code{\link[=cond_effect_boot]{cond_effect_boot()}},
users can request the percentile confidence intervals of
the bootstrap estimates. This method does not do the bootstrapping itself.
}
\examples{

# Load a sample data set

dat <- test_x_1_w_1_v_1_cat1_n_500

# Do a moderated regression by lm
lm_raw <- lm(dv ~ iv*mod + v1 + cat1, dat)
summary(lm_raw)
out <- cond_effect(lm_raw, x = iv, w = mod)
print(out, t_ci = TRUE)
confint(out)

lm_std <- std_selected(lm_raw, to_center = ~ iv + mod, to_scale = ~ iv + mod)
# Alternative: use to_standardize as a shortcut
# lm_std <- std_selected(lm_raw, to_standardize = ~ iv + mod)
out <- cond_effect(lm_std, x = iv, w = mod)
print(out, t_ci = TRUE)
confint(out)

# Categorical moderator
lm_cat <- lm(dv ~ iv*cat1 + v1, dat)
summary(lm_cat)
out <- cond_effect(lm_cat, x = iv, w = cat1)
print(out, t_ci = TRUE)
confint(out)

}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
