% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_int.R, R/stabilize_int_scalar.R,
%   R/to_int.R, R/to_int_scalar.R
\name{stabilize_int}
\alias{stabilize_int}
\alias{stabilize_int_scalar}
\alias{to_int}
\alias{to_int_scalar}
\title{Ensure an integer argument meets expectations}
\usage{
stabilize_int(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  min_size = NULL,
  max_size = NULL,
  min_value = NULL,
  max_value = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_int_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  min_value = NULL,
  max_value = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_int(
  x,
  allow_null = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_int_scalar(
  x,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{These dots are for future extensions and should be empty.}

\item{allow_null}{Logical. Is NULL an acceptable value?}

\item{allow_na}{Logical. Are NA values ok?}

\item{coerce_character}{Logical. Should character vectors such as "1" and
"2.0" be coerced to integer?}

\item{coerce_factor}{Logical. Should factors with values such as "1" and
"2.0" be coerced to integer? Note that this function uses the character
value from the factor, while \code{\link[=as.integer]{as.integer()}} uses the integer index of the
factor.}

\item{min_size}{Integer. The minimum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{Integer. The maximum size of the object. Object size will be
tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{min_value}{Integer scalar. The lowest allowed value for \code{x}. If \code{NULL}
(default) values are not checked.}

\item{max_value}{Integer scalar. The highest allowed value for \code{x}. If \code{NULL}
(default) values are not checked.}

\item{x_arg}{Character. An argument name for x. The automatic value will work
in most cases, or pass it through from higher-level functions to make error
messages clearer in unexported functions.}

\item{call}{The execution environment of the call. See the \code{call} argument of
\code{rlang::abort()} for more information.}

\item{x_class}{Character. The class name of \code{x} to use in error messages. Use
this if you remove a special class from \code{x} before checking its coercion,
but want the error message to match the original class.}

\item{allow_zero_length}{Logical. Are zero-length vectors acceptable?}
}
\value{
The argument as an integer.
}
\description{
\code{to_int()} checks whether an argument can be coerced to
integer without losing information, returning it silently if so.
Otherwise an informative error message is signaled.

\code{stabilize_int()} can check more details about the argument, but is slower
than \code{to_int()}.

\code{stabilize_int_scalar()} and \code{to_int_scalar()} are optimized to check for
length-1 integer vectors.
}
\examples{
to_int(1:10)
to_int("1")
to_int(1 + 0i)
to_int(NULL)
try(to_int(c(1, 2, 3.1, 4, 5.2)))
try(to_int("1", coerce_character = FALSE))
try(to_int(c("1", "2", "3.1", "4", "5.2")))

to_int_scalar("1")
try(to_int_scalar(1:10))

stabilize_int(1:10)
stabilize_int("1")
stabilize_int(1 + 0i)
stabilize_int(NULL)
try(stabilize_int(NULL, allow_null = FALSE))
try(stabilize_int(c(1, NA), allow_na = FALSE))
try(stabilize_int(letters))
try(stabilize_int("1", coerce_character = FALSE))
try(stabilize_int(factor(c("1", "a"))))
try(stabilize_int(factor("1"), coerce_factor = FALSE))
try(stabilize_int(1:10, min_value = 3))
try(stabilize_int(1:10, max_value = 7))

stabilize_int_scalar(1L)
stabilize_int_scalar("1")
try(stabilize_int_scalar(1:10))
stabilize_int_scalar(NULL)
try(stabilize_int_scalar(NULL, allow_null = FALSE))
}
