% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_extractor}
\alias{bf_extractor}
\title{Extract Bayes Factors from \code{BayesFactor} model object.}
\usage{
bf_extractor(
  bf.object,
  conf.level = 0.95,
  centrality = "median",
  conf.method = "hdi",
  k = 2L,
  top.text = NULL,
  output = "dataframe",
  ...
)
}
\arguments{
\item{bf.object}{An object from \code{BayesFactor} package.}

\item{conf.level}{Confidence/Credible Interval (CI) level. Default to \code{0.95}
(\verb{95\%}).}

\item{centrality}{The point-estimates (centrality indices) to compute.
Character (vector) or list with one or more of these options: \code{"median"},
\code{"mean"}, \code{"MAP"} or \code{"all"}.}

\item{conf.method}{The type of index used for Credible Interval. Can be
\code{"hdi"} (default), \code{"eti"}, or \code{"si"} (see \code{si()}, \code{hdi()}, \code{eti()}
functions from \code{bayestestR} package).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{top.text}{Text to display on top of the Bayes Factor message. This is
mostly relevant in the context of \code{ggstatsplot} functions.}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments passed to
\code{\link[parameters:model_parameters.BFBayesFactor]{parameters::model_parameters.BFBayesFactor()}}.}
}
\description{
Extract Bayes Factors from \code{BayesFactor} model object.
}
\note{
\emph{Important}: don't enter \code{1/bf.object} to extract results for null
hypothesis; doing so will return wrong results.
}
\examples{
\donttest{
# setup
library(statsExpressions)
set.seed(123)

# creating a `BayesFactor` object
bf_obj <-
  BayesFactor::anovaBF(
    formula = Sepal.Length ~ Species,
    data = iris,
    progress = FALSE
  )

# extracting Bayes Factors in a dataframe
bf_extractor(bf_obj)
}
}
