% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.condslope.log}
\alias{ci.condslope.log}
\title{Confidence interval for conditional (simple) slopes in a logistic model}
\usage{
ci.condslope.log(alpha, b1, b2, se1, se2, cov, lo, hi)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{b1}{sample coefficient for predictor variable}

\item{b2}{sample coefficient for product variable}

\item{se1}{standard error for predictor coefficient}

\item{se2}{standard error for product coefficient}

\item{cov}{sample covariance between predictor and product coefficients}

\item{lo}{low value of moderator variable}

\item{hi}{high value of moderator variable}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated condition slope
\item exp(Estimate) - estimated exponentiated condition slope
\item z - z test statistic
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals and test statistics for population
conditional slopes (simple slopes) in a general linear model that
includes a predictor variable that is the product of a moderator
variable and a predictor variable. Conditional slopes are computed
at low and high values of the moderator variable.
}
\examples{
ci.condslope.log(.05, .132, .154, .031, .021, .015, 5.2, 10.6)

# Should return:
#                   Estimate exp(Estimate)        z           p 
# At low moderator    0.9328      2.541616 2.269824 0.023218266 
# At high moderator   1.7644      5.838068 2.906507 0.003654887 
#                          LL        UL
# At low moderator   1.135802  5.687444
# At high moderator  1.776421 19.186357


}
