% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSTA.R
\name{STAtoTD}
\alias{STAtoTD}
\title{Convert STA to TD}
\usage{
STAtoTD(
  STA,
  what = c("BLUEs", "seBLUEs", "BLUPs", "seBLUPs"),
  traits = NULL,
  keep = NULL,
  addWt = FALSE
)
}
\arguments{
\item{STA}{An object of class \code{STA}.}

\item{what}{A character string containing the statistics to be included as
traits in the TD object. Multiple statistics can be included in which case
they will appear as \code{statistic_trait} in the output}

\item{traits}{A character string containing the traits to be included in the
TD object. If \code{NULL}, all traits are exported.}

\item{keep}{Columns from the TD object used as input for the STA model to
be copied to the output. see \code{\link{extractSTA}} for possible columns to
copy. If if it is available in \code{TD}, the column \code{trial} will always
be copied.}

\item{addWt}{Should a column wt be added to the output? If \code{TRUE}
weight is calculated as 1/(SE BLUEs) ^ 2. If multiple traits are included in
the output, multiple weight columns will be added, 1 for each trait. These
will be named \code{wt_trait}.}
}
\description{
Convert an STA object to a TD object.\cr
To be able to use the output of a single trial analysis in
Genotype-by-Environment (GxE) analysis the output first needs to be converted
back to an TD object. This function does exactly that. It extracts BLUEs,
BLUPs and their standard errors from the STA object and creates a new TD
object using these. Also a column "wt" (weight) may also be added. Weights
are then calculated as 1/(SE BLUEs) ^ 2.
}
\details{
Trial information for the trials in the STA object will be copied from the
original TD object on which the modeling was done.
}
\examples{
## Fit model using SpATS.
myModel <- fitTD(TD = TDHeat05, design = "res.rowcol", traits = "yield",
                 what = "fixed")

## Create TD object from the fitted model with BLUEs and standard errors.
myTD <- STAtoTD(myModel, what = c("BLUEs", "seBLUEs"))

## Add a weight column in the output.
myTDWt <- STAtoTD(myModel, what = c("BLUEs", "seBLUEs"), addWt = TRUE)

}
\seealso{
Other functions for STA objects: 
\code{\link{STAtoCross}()},
\code{\link{plot.STA}()},
\code{\link{report.STA}()},
\code{\link{summary.STA}()}
}
\concept{functions for STA objects}
