% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTimePoints.R
\name{removeTimePoints}
\alias{removeTimePoints}
\title{Remove time points from an object of class TP}
\usage{
removeTimePoints(TP, timePoints)
}
\arguments{
\item{TP}{An object of class TP.}

\item{timePoints}{A character or numeric vector indicating the time points
to be removed. When using a character string to reference a time point, the
value has to be an exact match to one of the existing timePoints. When using
a number it will be matched by its number ("timeNumber") in the timePoints
attribute of the TP object.}
}
\value{
An object of class TP, the input with the selected time points
removed.
}
\description{
Function for removing selected time points from an object of class TP.
}
\examples{
## Create a TP object containing the data from the Phenovator.
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3","check4"))
## Remove the first and last time point from the TP object.
phenoTPNew <- removeTimePoints(phenoTP,
                               timePoints = c(1, 73))

## Compare by looking at summaries.
summary(phenoTP)
summary(phenoTPNew)

}
\seealso{
Other functions for data preparation: 
\code{\link{as.data.frame.TP}()},
\code{\link{createTimePoints}()},
\code{\link{getTimePoints}()},
\code{\link{plot.TP}()},
\code{\link{summary.TP}()}
}
\concept{functions for data preparation}
