% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getVar}
\alias{getVar}
\title{Extract variances}
\usage{
getVar(fitMod, timePoints = names(fitMod), outFile = NULL)
}
\arguments{
\item{fitMod}{An object of class \code{fitMod}.}

\item{timePoints}{A character or numeric vector indicating the time point(s)
for which the variances should be extracted. When using a character
string to reference a time point, the value has to be an exact match to one
of the existing time points. When using a number it will be matched by its
number ("timeNumber") in the timePoints attribute of the TP object.}

\item{outFile}{A character string indicating the .csv file to which the
results should be written. If \code{NULL} no file is written.}
}
\value{
A data.frame with variances per time point.
}
\description{
Extract variances from an object of class fitMod.
}
\examples{
\donttest{
## Using the first example dataset (PhenovatorDat1):
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))

## Fit a SpATS model on few time points.
modPhenoSp <- fitModels(TP = phenoTP,
                        trait = "EffpsII",
                        timePoints = c(1, 6, 20))

## Extract the variances for all available time points.
getVar(modPhenoSp)
}

}
\seealso{
Other functions for spatial modeling: 
\code{\link{fitModels}()},
\code{\link{getCorrected}()},
\code{\link{getEffDims}()},
\code{\link{getGenoPred}()},
\code{\link{getHerit}()},
\code{\link{plot.fitMod}()},
\code{\link{summary.fitMod}()}
}
\concept{functions for spatial modeling}
