% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gxeFw.R
\name{gxeFw}
\alias{gxeFw}
\title{Finlay-Wilkinson analysis}
\usage{
gxeFw(
  TD,
  trials = names(TD),
  trait,
  maxIter = 15,
  tol = 0.001,
  sorted = c("descending", "ascending", "none"),
  genotypes = NULL,
  useWt = FALSE
)
}
\arguments{
\item{TD}{An object of class \code{\link[statgenSTA]{TD}}.}

\item{trials}{A character string specifying the trials to be analyzed. If
not supplied, all trials are used in the analysis.}

\item{trait}{A character string specifying the trait to be analyzed.}

\item{maxIter}{An integer specifying the maximum number of iterations in
the algorithm.}

\item{tol}{A positive numerical value specifying convergence tolerance of the
algorithm.}

\item{sorted}{A character string specifying the sorting order of the
estimated values in the output.}

\item{genotypes}{An optional character string containing the genotypes to
which the analysis should be restricted. If \code{NULL}, all genotypes are
used.}

\item{useWt}{Should weighting be used when modeling? Requires a column
\code{wt} in \code{TD}.}
}
\value{
An object of class \code{\link{FW}}, a list containing:
\item{estimates}{A data.frame containing the estimated values, with the
following columns:
\itemize{
\item genotype: The name of the genotype.
\item sens: The estimate of the sensitivity.
\item se_sens: The standard error of the estimate of the sensitivity.
\item genMean: The estimate of the genotypic mean.
\item se_genMean: The standard error of the estimate of the genotypic
mean.
\item MSdeviation: The mean square deviation about the line fitted to
each genotype
\item rank: The rank of the genotype based on its sensitivity.
}
}
\item{anova}{A data.frame containing anova scores of the FW analysis.}
\item{envEffs}{A data.frame containing the environmental effects, with the
following columns:
\itemize{
\item trial: The name of the trial.
\item envEff: The estimate of the environment effect.
\item se_envEff: The standard error of the estimate of the environment
effect.
\item envMean: The estimate of the environment mean.
\item rank: The rank of the trial based on its mean.
}
}
\item{TD}{The object of class TD on which the analysis was performed.}
\item{fittedGeno}{A numerical vector containing the fitted values for the
genotypes.}
\item{trait}{A character string containing the analyzed trait.}
\item{nGeno}{A numerical value containing the number of genotypes in the
analysis.}
\item{nEnv}{A numerical value containing the number of environments in the
analysis.}
\item{tol}{A numerical value containing the tolerance used during the
analysis.}
\item{iter}{A numerical value containing the number of iterations for the
analysis to converge.}
}
\description{
This function performs a Finlay-Wilkinson analysis of data classified by two
factors.
}
\examples{
## Run Finlay-Wilkinson analysis on TDMaize.
geFW <- gxeFw(TDMaize, trait = "yld")

## Summarize results.
summary(geFW)

## Create a scatterplot of the results.
plot(geFW, plotType = "scatter")

\donttest{
## Create a report summarizing the results.
report(geFW, outfile = tempfile(fileext = ".pdf"))
}

}
\references{
Finlay, K.W. & Wilkinson, G.N. (1963). The analysis of adaptation
in a plant-breeding programme. Australian Journal of Agricultural
Research, 14, 742-754.
}
\seealso{
Other Finlay-Wilkinson: 
\code{\link{fitted.FW}()},
\code{\link{plot.FW}()},
\code{\link{report.FW}()},
\code{\link{residuals.FW}()}
}
\concept{Finlay-Wilkinson}
