% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lead-lag}
\alias{lag.default}
\alias{lead}
\alias{lead-lag}
\title{lead and lag with respect to a time variable}
\usage{
lead(x, n = 1L, order_by = NULL, along_with = NULL, units = NULL,
  default = NA, ...)

\method{lag}{default}(x, n = 1L, order_by = NULL, along_with = NULL,
  units = NULL, default = NA, ...)
}
\arguments{
\item{x}{a vector of values}

\item{n}{a positive integer of length 1, giving the number of positions to lead or lag by. When the package lubridate is loaded, it can be a period when using with along_with (see the lubridate function minutes, hours, days, weeks, months and years)}

\item{order_by}{override the default ordering to use another vector}

\item{along_with}{use this variable to lag with respect to \code{n} \code{along_with} rather than \code{n} row}

\item{units}{Deprecated. Use \code{elapsed_dates}}

\item{default}{value used for non-existant rows. Defaults to \code{NA}.}

\item{...}{Needed for compatibility with lag generic.}
}
\description{
lead and lag with respect to a time variable
}
\examples{
year <- c(1989, 1991, 1992)
value <- c(4.1, 4.5, 3.3)
lag(value, 1, order_by = year) # returns value in previous year, like  dplyr::lag
lag(value, 1, along_with = year) #  returns value in year - 1
lead(value, 1, along_with = year)
library(lubridate)
date <- mdy(c("01/04/1992", "03/15/1992", "04/03/1992"))
value <- c(4.1, 4.5, 3.3)
datem <- as.monthly(date)
lag(value, along_with = datem)
}

