% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMXStanFit.R
\name{waic}
\alias{waic}
\title{Diagnostics for a fitted Bayesian model}
\usage{
waic(fit, complete = FALSE)
}
\arguments{
\item{fit}{a \code{PMXStanFit} object.}

\item{complete}{a logical to select whether to input all pointwise and total statistics (\code{TRUE}) 
or only total statistics (\code{FALSE}, by default).}
}
\description{
Calculates diagnostic statistics for a fitted Bayesian model: \emph{Watanabe-Akaike information criterion} 
(\code{WAIC}) and \emph{Leave-on-out cross-validation} (\code{LOO-CV}). This is a generic version of the 
method \code{get.waic()} for the \code{\link{PMXStanFit}} class.
}
\value{No return value, called for side effects}
\examples{
\donttest{
m1 <- PMXStanModel(path = tempfile("pk_m1"), pk.struct = "1-cmpt", compile=TRUE)

data("examples_data")
dat <- prepareInputData(data.source = d1_nm_poppk, model = m1)
fit <- PMXStanFit(m1, dat, iter=100, chains=1)

fit$get.waic()
waic(fit, complete = TRUE)
}
}
\seealso{
\code{\link{PMXStanFit}} for the method \code{get.waic()}, and related references.
}

