% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-inference-functions.R
\name{prob}
\alias{prob}
\title{Probabilities for a staged event tree}
\usage{
prob(object, x, log = FALSE, na0 = TRUE)
}
\arguments{
\item{object}{an object of class \code{sevt} with probabilities.}

\item{x}{the vector or data.frame of observations.}

\item{log}{logical, if \code{TRUE} log-probabilities are returned.}

\item{na0}{logical, if \code{NA} should be converted to 0.}
}
\value{
the probabilities to observe each observation given in \code{x}.
}
\description{
Compute (marginal) probabilities of elementary events with respect
to the probability encoded in a staged event tree.
}
\details{
Computes probabilities related to a vector or a
data.frame of observations.
}
\examples{
DD <- generate_random_dataset(5, 100)
model <- full(DD, lambda = 1)
pr <- prob(model, expand.grid(model$tree[c(2, 3, 4)]))
sum(pr)
prob(model, DD[1:10, ])
}
