% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1b-base-model-function.R
\name{compare_stages}
\alias{compare_stages}
\alias{hamming_stages}
\alias{diff_stages}
\title{Compare two staged event tree}
\usage{
compare_stages(
  object1,
  object2,
  method = "naive",
  return_tree = FALSE,
  plot = FALSE,
  ...
)

hamming_stages(object1, object2, return_tree = FALSE)

diff_stages(object1, object2)
}
\arguments{
\item{object1}{an object of class \code{sevt}.}

\item{object2}{an object of class \code{sevt}.}

\item{method}{character, method to compare staged event trees.
One of: \code{"naive"},
\code{"hamming"} or \code{"stages"}.}

\item{return_tree}{logical, if \code{TRUE} the difference tree is returned.}

\item{plot}{logical.}

\item{...}{additional parameters to be passed to \code{\link{plot.sevt}}.}
}
\value{
\code{compare_stages}: if \code{return_tree = FALSE}, logical: \code{TRUE} if the two
models are exactly equal, otherwise \code{FALSE}.
Else if \code{return_tree = TRUE}, the differences between
the two trees, according to the selected \code{method}.

\code{hamming_stages}: if \code{return_tree = FALSE}, integer, the minimum
number of situations where the stage should be changed to obtain the same
models. If \code{return_tree = TRUE} a stages-like structure showing which
situations should be modified to obtain the same models.

\code{diff_stages}: a stages-like structure marking the situations belonging
to stages which are not the exactly equal.
}
\description{
Compare two staged event trees, return the differences of the stages
structure and plot the difference tree. Three different methods to
compute the difference tree are available (see Details).
}
\details{
\code{compare_stages} tests if the stage structure of two \code{sevt}
objects
is the same.
Three methods are available:
\itemize{
\item \code{naive} first applies \code{\link{stndnaming}} to both
objects and then simply compares the resulting stage names.
\item \code{hamming} uses the \code{hamming_stages} function that finds
a minimal subset of nodes which stages
must be changed to obtain the same structure.
\item \code{stages} uses the \code{diff_stages} function that compares
stages to check whether the same stage structure is present in both models.
}

Setting \code{return_tree = TRUE} will return the stages
difference obtained with the selected method.
The stages difference is a list of numerical vectors with same
lengths and structure as \code{stages(object1)} or \code{stages(object2)},
where values are 1 if the corresponding node has different
(with respect to the selected \code{method}) associated stage, and
0 otherwise.

With \code{plot = TRUE} the plot of the difference tree is displayed.

If \code{return_tree = FALSE} and \code{plot = FALSE}
the logical output is the same for the
three methods and thus the \code{naive} method should be used
since it is computationally faster.

\code{hamming_stages} finds a minimal set of nodes for which the associated stages
should be changed to obtain equivalent structures. To do that, a maximum-weight bipartite
matching problem between the stages of the two staged trees is solved using the
Hungarian method implemented in the \code{solve_LSAP} function of the \code{clue}
package.
\code{hamming_stages} requires the package \code{clue}.
}
\examples{
data("Asym")
mod1 <- stages_bhc(full(Asym, lambda = 1))
mod2 <- stages_fbhc(full(Asym, lambda = 1))
compare_stages(mod1, mod2)

##########
m0 <- full(PhDArticles[, 1:4], lambda = 0)
m1 <- stages_bhc(m0)
m2 <- stages_bj(m0, distance = "totvar", thr = 0.25)
diff_stages(m1, m2)
}
