% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-inference-functions.R
\name{path_probability.sevt}
\alias{path_probability.sevt}
\title{Compute probability of a path from root}
\usage{
path_probability.sevt(object, x, log = FALSE)
}
\arguments{
\item{object}{a staged event tree object}

\item{x}{the path, expressed as a character vector containing the sequence of the assumed levels}

\item{log}{logical, if \code{TRUE} log-probability is returned}
}
\value{
The probability of the given path or its logarithm if \code{log=TRUE}
}
\description{
Compute probability of a path from root
}
\details{
it computes the probability of following a given path (\code{x}) starting from the root.
Can be a full path from the root to a leaf or a shorter path.
}
\examples{
DD <- generate_random_dataset(5, 100)
model <- staged_ev_tree(DD, fit = TRUE, lambda = 1)
path_probability.sevt(model, c("1", "-1", "1", "-1", "1"), log = TRUE)  # root to leaf path
path_probability.sevt(model, c("1", "-1"))  # short path

grid <- expand.grid(model$tree)  # all paths from root to leaves

# joint distribution. it sums up to 1.
grid.prob <- apply(t(apply(grid, 1, as.character)), 1, path_probability.sevt, object = model) 
cbind(grid, grid.prob)
}
