% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/ddispl.R
\name{ddispl}
\alias{ddispl}
\title{Discrete Powerlaw Probability Mass Function}
\usage{
ddispl(x, xmin, alpha, log = FALSE)
}
\arguments{
\item{x}{Vector of quantiles.}

\item{xmin}{The lower bound of the powerlaw distribution.}

\item{alpha}{The scaling parameter.}

\item{log}{Logical, whether return log values. By default is set to FALSE.}
}
\description{
Probability mass function for the discrete power law distribution with parameters xmin and alpha.
}
\examples{
x = rdispl(n = 1e4, xmin = 10, alpha = 2.5)
ddispl(x, xmin = 10, alpha = 2.5, log = FALSE)
}
\keyword{complementary}
\keyword{density}
\keyword{discrete}
\keyword{distribution}
\keyword{function}
\keyword{powerlaw}

