% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_model_components.R
\name{extract_model_components}
\alias{extract_model_components}
\title{Extract Model Components for Selection Models}
\usage{
extract_model_components(
  selection,
  outcome,
  data,
  outcomeS = NULL,
  outcomeC = NULL,
  drop.levels = TRUE
)
}
\arguments{
\item{selection}{A formula for the selection equation.}

\item{outcome}{A formula for the outcome equation.}

\item{data}{A data frame containing all variables.}

\item{outcomeS}{Optional formula or matrix for the dispersion model (\code{sigma}).}

\item{outcomeC}{Optional formula or matrix for the correlation model (\code{rho}).}

\item{drop.levels}{Logical. If \code{TRUE}, drops unused factor levels.}
}
\value{
A list with the following components:
\describe{
  \item{\code{XS}}{Model matrix for the selection equation.}
  \item{\code{YS}}{Response vector for the selection equation.}
  \item{\code{NXS}}{Number of covariates in the selection model.}
  \item{\code{XO}}{Model matrix for the outcome equation.}
  \item{\code{YO}}{Response vector for the outcome equation.}
  \item{\code{NXO}}{Number of covariates in the outcome model.}
  \item{\code{Msigma}}{Matrix for the dispersion model (or \code{NULL} if not provided).}
  \item{\code{NE}}{Number of covariates for the dispersion model (0 if not provided).}
  \item{\code{Mrho}}{Matrix for the correlation model (or \code{NULL} if not provided).}
  \item{\code{NV}}{Number of covariates for the correlation model (0 if not provided).}
  \item{\code{YSLevels}}{Factor levels of the binary selection response.}
}
}
\description{
This internal utility function extracts key components—such as model frames, matrices,
and response variables—from formulas and a data set. It is used by models like
\code{HeckmanCL}, \code{HeckmanGe}, \code{HeckmanSK}, \code{HeckmanBS}, and \code{HeckmantS}.
Additionally, it can handle covariate matrices for modeling dispersion (\code{sigma}) and
correlation (\code{rho}) structures.
}
\details{
If provided, \code{outcomeS} and \code{outcomeC} can be formulas or matrices for modeling
dispersion and correlation structures, respectively. The function ensures that the
selection equation response is binary.
}
\keyword{internal}
