% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.R
\name{gamma}
\alias{gamma}
\alias{dgamma}
\alias{pgamma}
\alias{qgamma}
\alias{rgamma}
\alias{sgamma}
\title{Gamma Distribution}
\usage{
dgamma(x, shape = 1, scale = 1, log = FALSE)

pgamma(q, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

qgamma(p, shape = 1, scale = 1, lower.tail = TRUE, log.p = FALSE)

rgamma(n, shape = 1, scale = 1)

sgamma(x)
}
\arguments{
\item{x}{A numeric vector of values.}

\item{shape}{A string of the column in data for the shape aesthetic.}

\item{scale}{scale parameter.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x],otherwise, P[X > x].}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
A numeric vector.
}
\description{
Density, distribution function, quantile function and random generation for the Gamma distribution with #' parameters shape and scale with default values.
}
\examples{
x <- seq(0.01, 5, by = 0.01)
plot(x, dgamma(x), type = "l")
}
\seealso{
\code{\link[stats]{dgamma}}
}
