% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{plot_scores}
\alias{plot_scores}
\title{Plots of score distribution}
\usage{
plot_scores(X, PC, groups, ssMRCD, ...)
}
\arguments{
\item{X}{data matrix.}

\item{PC}{loadings from PCA.}

\item{groups}{vector containing group assignments.}

\item{ssMRCD}{ssMRCD object.}

\item{...}{other input arguments, see details.}
}
\value{
Returns histograms of scores for component \code{k}.
}
\description{
Plots of score distribution
}
\details{
Additional parameters that can be given to the function are: \tabular{ll}{
   \code{shape} \tab point shape  \cr
   \tab \cr
   \code{size} \tab point size \cr
   \tab \cr
   \code{alpha} \tab transparency  \cr
   \tab \cr
   \code{k} \tab integer, which component scores should be plotted \cr
   \tab \cr
}
}
\examples{
# set seed
set.seed(236)

data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariance matrices
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# sparse PCA
pca = sparsePCAloc(eta = 0.3, gamma = 0.7, cor = FALSE, COVS = covs$MRCDcov,
             n_max = 1000, increase_rho = list(TRUE, 50, 1), trace = FALSE)

# plot score distances
plot_scores(PC = pca$PC,
            groups = groups,
            X = data,
            ssMRCD = covs,
            k = 1,
            alpha = 0.4,
            shape = 16,
            size = 2)
}
