% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCA_helpers.R
\name{align_PC}
\alias{align_PC}
\title{Align Loadings of Principal Components}
\usage{
align_PC(PC, N, p, type = "largest", vec = NULL)
}
\arguments{
\item{PC}{matrix of loadings of size Np x k}

\item{N}{integer, number of groups/neighborhoods}

\item{p}{integer, number of variables}

\item{type}{character indicating how loadings are aligned (see details),
options are \code{"largest", "maxvar","nonzero","mean", "scalar", "none"}.}

\item{vec}{\code{NULL} or vector containing vectors for type \code{"scalar"}}
}
\value{
Returns a matrix of loadings of size \code{Np} times \code{k}.
}
\description{
Aligns loadings per neighborhood for better visualization and comparison. Different options are available.
}
\details{
For input \code{type} possible values are \code{"largest", "maxvar","nonzero","mean","scalar"}.
For option \code{"maxvar"} the variable with the highest absolute value in the loading
is scaled to be positive (per neighborhood, per loading).
For option \code{"nonzero"} the variable with largest distance to zero in the entries is
scaled to be positive (per neighborhood, per loading).
For option \code{"scalar"} the variable is scaled in a way, that the scalar product
between the loading and the respective part of \code{vec} is positive (per neighborhood, per loading).
If \code{vec} is of size \code{p} times \code{k}, the same vector is used for all neighborhoods.
Option \code{"mean"} is option \code{"scalar"} with \code{vec} being the mean of the loadings per variable across neighborhoods.
Option \code{"largest"} scales the largest absolute value to be positive per neighborhood and per PC.
Option \code{"none"} does nothing and returns \code{PC}.
}
\examples{
x = matrix(c(1, 0, 0, 0, sqrt(0.5), -sqrt(0.5), 0, 0,
             0, sqrt(1/3), -sqrt(1/3), sqrt(1/3), sqrt(0.5), sqrt(0.5), 0, 0),
           ncol = 2)
align_PC(PC = x, N = 2, p = 4, type = "largest")
align_PC(PC = x, N = 2, p = 4, type = "mean")
}
