% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostatSim.R
\name{geostatSim}
\alias{geostatSim}
\title{Simulate geostatistical data on set of given locations}
\usage{
geostatSim(
  loc.data,
  xcol = "x",
  ycol = "y",
  parsil = 1,
  range = 1,
  nugget = 0,
  minorp = 1,
  rotate = 90,
  extrap = NULL,
  CorModel = "Exponential"
)
}
\arguments{
\item{loc.data}{data.frame with x- and y-coordinates of locations for simulated data}

\item{xcol}{name of the column in loc.data with x-coordinates, default is "x"}

\item{ycol}{name of the column loc.data with y-coordinates, default is "y"}

\item{parsil}{partial sill of autocorrelation model, default = 1}

\item{range}{range of autocorrelation model, default = 1}

\item{nugget}{range of autocorrelation model, default = 0}

\item{minorp}{proportion of range in x direction to that of y direction for unrotated anisotropic model, default = 1}

\item{rotate}{rotation of anisotropic axes, default = 90}

\item{extrap}{extra covariance paramter}

\item{CorModel}{autocorrelation model, default = "Exponential".  Other possibilities are "Spherical".}
}
\value{
data.frame of three columns, the original location data appended with a 3rd column of simulated geostatistical data
}
\description{
Spatially correlated data are simulated assuming a multivariate normal
random error vector. For simplicity, only \code{"Exponential"} and \code{"Spherical"} simulation options are given here.
}
\examples{
locations <- expand.grid(1:10, 1:10)
geostatSim(locations, xcol = "Var1", ycol = "Var2",
parsil = 4, range = 20, nugget = 1, CorModel = "Exponential")
}
\author{
Jay Ver Hoef
}
