% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interp.cdf.R
\name{interp.cdf}
\alias{interp.cdf}
\title{Interpolate CDF Values at a Set of Percentiles}
\usage{
interp.cdf(pctval, cdfest.p, cdf.value)
}
\arguments{
\item{pctval}{Vector of percentiles (expressed as percents) at which the
CDF values are to be interpolated.}

\item{cdfest.p}{Vector of CDF estimates in terms of proportions.}

\item{cdf.value}{Vector of CDF values to be interpolated.}
}
\value{
A numeric vector consisting of the interpolated CDF values.
}
\description{
This function interpolates CDF values at a set of percentiles.  The CDF
values can be CDF estimates, CDF confidence bound estimates, or values at
which the CDF is estimated (i.e., x-axis values).  It is assumed that
arguments cdfest.p and cdf.value are strictly increasing.
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}\cr
  Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
