\name{relrisk.analysis}
\alias{relrisk.analysis}
\title{Relative Risk Analysis for Probability Survey Data}
\description{
  This function organizes input and output for relative risk analysis of 
  categorical data generated by a probability survey.
}
\usage{
relrisk.analysis(sites, subpop, design, data.rr, response.var, stressor.var,
   response.levels=rep(list(c("Poor","Good")), length(response.var)),
   stressor.levels=rep(list(c("Poor","Good")), length(stressor.var)),
   popcorrect=FALSE, pcfsize=NULL, N.cluster=NULL, stage1size=NULL,
   sizeweight=FALSE, vartype="Local", conf=95)
}
\arguments{
  \item{sites}{a data frame consisting of two variables: the first variable is 
    site IDs, and the second variable is a logical vector indicating which
    sites to use in the analysis.  The default is NULL.}
  \item{subpop}{a data frame describing sets of populations and subpopulations 
    for which estimates will be calculated.  The first variable is site  
    IDs.  Each subsequent variable identifies a Type of population, where
    the variable name is used to identify Type.  A Type variable
    identifies each site with one of the subpopulations of that Type.  The
    default is NULL.}
  \item{design}{a data frame consisting of design variables.  The default is
    NULL.  Variables should be named as follows:\cr
       siteID = site IDs\cr
       wgt = final adjusted weights, which are either the weights for a
         single-stage sample or the stage two weights for a two-stage sample\cr
       xcoord = x-coordinates for location, which are either the x-coordinates
         for a single-stage sample or the stage two x-coordinates for a
         two-stage sample\cr
       ycoord = y-coordinates for location, which are either the y-coordinates
         for a single-stage sample or the stage two y-coordinates for a
         two-stage sample\cr
       stratum = the stratum codes\cr
       cluster = the stage one sampling unit (primary sampling unit or cluster)
         codes\cr
       wgt1 = final adjusted stage one weights\cr
       xcoord1 = the stage one x-coordinates for location\cr
       ycoord1 = the stage one y-coordinates for location\cr
       support = support values - the value one (1) for a site from a 
         finite resource or the measure of the sampling unit associated 
         with a site from an extensive resource, which is required for 
         calculation of finite and continuous population correction 
         factors\cr
       swgt = size-weights, which is the stage two size-weight for a two-
         stage sample\cr
       swgt1 = stage one size-weights}
  \item{data.rr}{data frame of categorical response and stressor variables, 
    where each variable consists of two categories.  If response or stressor 
    variables include more than two categories, occurrences of those categories 
    must be removed or replaced with missing values.  The first column of this 
    argument is site IDs.  Subsequent columns are response and stressor 
    variables.  Missing data (NA) is allowed.}
  \item{response.var}{character vector providing names of columns in argument 
    data.rr that contain a response variable, where names may be repeated. Each 
    name in this argument is matched with the corresponding value in the 
    stressor.var argument.}
  \item{stressor.var}{character vector providing names of columns in argument 
    data.rr that contain a stressor variable, where names may be repeated. Each 
    name in this argument is matched with the corresponding value in the 
    response.var argument.  This argument must be the same length as argument 
    response.var.}
  \item{response.levels}{list providing the category values (levels) for each 
    element in the response.var argument.  This argument must be the same length 
    as argument response.var.  The first level for each element in the list is 
    used for calculating the numerator and the denominator of the relative risk 
    estimate.  The default is a list containing the values "Poor" and "Good" for 
    the first and second levels, respectively, of each element in the 
    response.var argument.}
  \item{stressor.levels}{list providing the category values (levels) for each 
    element in the stressor.var argument.  This argument must be the same length 
    as argument response.var.  The first level for each element in the list is 
    used for calculating the numerator of the relative risk estimate, and the 
    second level for each element in the list is used for calculating the 
    denominator of the estimate.  The default is a list containing the values 
    "Poor" and "Good" for the first and second levels, respectively, of each 
    element in the stressor.var argument.}
  \item{popcorrect}{a logical value that indicates whether finite or continuous 
    population correction factors should be employed during variance 
    estimation, where TRUE = use the correction factors and FALSE = do not 
    use the correction factors.  The default is FALSE.}
  \item{pcfsize}{size of the resource, which is required for calculation of
    finite and continuous population correction factors for a single-stage
    sample.  For a stratified sample this argument must be a vector containing a
    value for each stratum and must have the names attribute set to identify the
    stratum codes.  The default is NULL.}
  \item{N.cluster}{the number of stage one sampling units in the resource, which 
    is required for calculation of finite and continuous population 
    correction factors for a two-stage sample.  For a stratified sample 
    this variable must be a vector containing a value for each stratum and
    must have the names attribute set to identify the stratum codes.  The
    default is NULL.}
  \item{stage1size}{size of the stage one sampling units of a two-stage sample,
    which is required for calculation of finite and continuous population
    correction factors for a two-stage sample and must have the names
    attribute set to identify the stage one sampling unit codes.  For a
    stratified sample, the names attribute must be set to identify both
    stratum codes and stage one sampling unit codes using a convention where
    the two codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".
    The default is NULL.}
  \item{sizeweight}{a logical value that indicates whether size-weights should 
    be used in the analysis, where TRUE = use the size-weights and FALSE = 
    do not use the size-weights.  The default is FALSE.}
  \item{vartype}{the choice of variance estimator, where "Local" = local mean
    estimator and "SRS" = SRS estimator.  The default is "Local".}
  \item{conf}{the confidence level.  The default is 95\%.}
}
\value{
  Value is a data frame of relative risk estimates for all combinations of 
  population Types, subpopulations within Types, and response variables.  
  Standard error and confidence interval estimates also are provided.
}
\references{
  Sarndal, C.E., B. Swensson, and J. Wretman. (1992). \emph{Model Assisted
  Survey Sampling}. Springer-Verlag, New York.
}
\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\seealso{
\code{\link{relrisk.est}} 
}
\examples{
mysiteID <- paste("Site", 1:100, sep="")
mysites <- data.frame(siteID=mysiteID, Active=rep(TRUE, 100))
mysubpop <- data.frame(siteID=mysiteID, All.Sites=rep("All Sites", 100),
  Resource.Class=rep(c("Agr", "Forest"), c(55,45)))
mydesign <- data.frame(siteID=mysiteID, wgt=runif(100, 10, 100),
  xcoord=runif(100), ycoord=runif(100), stratum=rep(c("Stratum1",
  "Stratum2"), 50))
mydata.rr <- data.frame(siteID=mysiteID, RespVar1=sample(c("Poor", "Good"),
  100, replace=TRUE), RespVar2=sample(c("Poor", "Good"), 100, replace=TRUE),
  StressVar=sample(c("Poor", "Good"), 100, replace=TRUE), wgt=runif(100, 10,
  100))
relrisk.analysis(sites=mysites, subpop=mysubpop, design=mydesign,
  data.rr=mydata.rr, response.var=c("RespVar1", "RespVar2"),
  stressor.var=rep("StressVar", 2))
}
\keyword{survey}
\keyword{survival}
