% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popover_tip.R
\name{bsPopover}
\alias{bsPopover}
\alias{bsHoverPopover}
\alias{bsPop}
\title{Enhanced Bootstrap3 popover}
\usage{
bsPopover(
  tag,
  title = "",
  content = "",
  placement = "top",
  bgcolor = "#ebebeb",
  titlecolor = "black",
  contentcolor = "black",
  titlesize = "14px",
  contentsize = "12px",
  titleweight = "600",
  contentweight = "400",
  opacity = 1,
  html = FALSE,
  trigger = "hover",
  click_inside = FALSE
)

bsHoverPopover(
  tag,
  title = "",
  content = "",
  placement = "top",
  bgcolor = "#ebebeb",
  titlecolor = "black",
  contentcolor = "black",
  titlesize = "14px",
  contentsize = "12px",
  titleweight = "600",
  contentweight = "400",
  opacity = 1,
  html = FALSE,
  trigger = "hover",
  click_inside = FALSE
)

bsPop(
  tag,
  title = "",
  content = "",
  placement = "top",
  status = "primary",
  titlesize = "14px",
  contentsize = "12px",
  titleweight = "600",
  contentweight = "400",
  opacity = 1,
  html = TRUE,
  trigger = "hover",
  click_inside = FALSE
)
}
\arguments{
\item{tag}{a shiny tag as input}

\item{title}{string, popover title}

\item{content}{string, popover cotent}

\item{placement}{string, one of "top", "bottom", "left", "right", where to put the
tooltip}

\item{bgcolor}{string, background color, valid value of CSS color name or hex value or rgb value}

\item{titlecolor}{string, title text color, valid value of CSS color name or hex value or rgb value}

\item{contentcolor}{string, content text color, valid value of CSS color name or hex value or rgb value}

\item{titlesize}{string, title text font size, valid value of CSS font size, like "10px", "1rem".}

\item{contentsize}{string, content text font size, valid value of CSS font size, like "10px", "1rem".}

\item{titleweight}{string, CSS valid title font weight unit}

\item{contentweight}{string, CSS valid content font weight unit}

\item{opacity}{numeric, between 0 and 1}

\item{html}{bool, allow title contain HTML code? like \code{"<strong>abc</strong>"}}

\item{trigger}{string, how to trigger the tooltip, one or combination of
click | hover | focus | manual.}

\item{click_inside}{bool, default is \code{FALSE}, whether to allow users to
click content inside the message. See details.}

\item{status}{string, used only for wrapper \link{bsPop}, see details}
}
\value{
shiny tag
}
\description{
Add popover to any Shiny element you want. You can also customize
color, font size, background color, and more for each individual popover.
}
\details{
\enumerate{
\item For trigger methods read: https://getbootstrap.com/docs/3.3/javascript/#tooltips-options.
\item For font weight, see: https://www.w3schools.com/cssref/pr_font_weight.asp
\item \link{bsHoverPopover} is the old name but we still keep it for backward compatibility.
}
\subsection{Click inside the message}{

Sometimes developers want to add links for users to click.
By default, the message will be gone once mouse leaves the element, but with
this option to be \code{TRUE}, when users move the mouse inside, the message
element will not be gone, so users can click on the links or other content.

Once this option is used, the triggering method is set to \code{"manual"} and
animation will be removed. This is related to the Javascript method used
behind, some compromises have to be made.

When adding the links, you may also want to turn \code{html = TRUE} in combined.
}

\subsection{Convenient wrapper function}{

\link{bsPop} is the convenient function for \link{bsPopover}, which has the background
and content color set to 5 different bootstrap colors, you can use \code{status}
to set, one of "primary", "info", "success", "warning", "danger"
}
}
\examples{
if(interactive()){
  library(shiny)
  library(magrittr)
  ui <- fluidPage(
    br(), br(), br(), br(), br(), br(), column(2),
    actionButton("", "Popover on the left") \%>\%
      bsPopover("Popover on the left", "content", "left"),
    actionButton("", "Popover on the top") \%>\%
      bsPopover("Popover on the top", "content", "top"),
    actionButton("", "Popover on the right") \%>\%
      bsPopover("Popover on the right", "content", "right"),
    actionButton("", "Popover on the bottom") \%>\%
      bsPopover("Popover on the bottom", "content", "bottom"),
    br(), br(), column(2),
    actionButton("", "primary color") \%>\%
      bsPopover(
        "primary color", "content", bgcolor = "#0275d8",
        titlecolor = "white", contentcolor = "#0275d8"),
    actionButton("", "danger color") \%>\%
      bsPopover(
        "danger color",  "content", bgcolor = "#d9534f",
        titlecolor = "white", contentcolor = "#d9534f"),
    actionButton("", "warning color") \%>\%
      bsPopover(
        "warning color", "content", bgcolor = "#f0ad4e",
        titlecolor = "white", contentcolor = "#f0ad4e"),
    br(), br(), column(2),
    actionButton("", "9px & 14px") \%>\%
      bsPopover("9px", "14", titlesize = "9px", contentsize = ),
    actionButton("", "14px & 12px") \%>\%
      bsPopover("14px", "12", titlesize = "14px"),
    actionButton("", "20px & 9px") \%>\%
      bsPopover("20px", "9", titlesize = "20px"),
    br(), br(), column(2),
    actionButton("", "weight 100 & 800") \%>\%
      bsPopover("weight 100", "800", titleweight =  "100", contentweight = "800"),
    actionButton("", "weight 400 & 600") \%>\%
      bsPopover("weight 400", "600", titleweight =  "400", contentweight = "600"),
    actionButton("", "weight 600 & 400") \%>\%
      bsPopover("weight 600", "400", titleweight =  "600", contentweight = "400"),
    actionButton("", "weight 900 & 200") \%>\%
      bsPopover("weight 900", "200", titleweight =  "900", contentweight = "200"),
    br(), br(), column(2),
    actionButton("", "opacity 0.2") \%>\%
      bsPopover("opacity 0.2", opacity = 0.2),
    actionButton("", "opacity 0.5") \%>\%
      bsPopover("opacity 0.5", opacity = 0.5),
    actionButton("", "opacity 0.8") \%>\%
      bsPopover("opacity 0.8", opacity = 0.8),
    actionButton("", "opacity 1") \%>\%
      bsPopover("opacity 1", opacity = 1),
    br(), br(), column(2),
    actionButton("f1", "allow html: 'abc<span class='text-danger'>danger</span>'") \%>\%
      bsPopover(HTML("abc<span class='text-danger'>danger</span>"),
                html = TRUE, bgcolor = "#0275d8"),
    actionButton("f2", "allow html: '<s>del content</s>'") \%>\%
      bsPopover(HTML("<s>del content</s>"), html = TRUE, bgcolor = "#d9534f"),
    actionButton("", "Clickable with links") \%>\%
      bsPopover(
         title = "Clickable with links",
         content = "<div>This message has a <a href='https://google.com'>link</a></div>", "bottom",
         html = TRUE, click_inside = TRUE, bgcolor = "orange"
       )
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
if(interactive()){
  library(shiny)
  library(magrittr)
  ui <- fluidPage(
    br(), br(), br(), br(), br(), br(), column(2),
    actionButton("", "primary") \%>\%
      bsPop("primary", "primary", status = "primary"),
    actionButton("", "info") \%>\%
      bsPop("info", "info", status = "info"),
    actionButton("", "success") \%>\%
      bsPop("success", "success", status = "success"),
    actionButton("", "warning") \%>\%
      bsPop("warning", "warning", status = "warning"),
    actionButton("", "danger") \%>\%
      bsPop("danger", "danger", status = "danger")
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
}
