% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_awesome_animate.R
\name{animateUI}
\alias{animateUI}
\alias{animateServer}
\alias{animationRemove}
\title{Add/remove animation to any HTML/shiny component}
\usage{
animateUI(selector, animation, speed = NULL, hover = FALSE, isID = TRUE)

animateServer(
  selector,
  animation = NULL,
  speed = NULL,
  hover = FALSE,
  isID = TRUE,
  session = shiny::getDefaultReactiveDomain()
)

animationRemove(
  selector,
  isID = TRUE,
  alert = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{selector}{string, a shiny component ID or a valid CSS selector if \code{isID = FLASE}.
for example, you have a button and want to add animation to it:

\if{html}{\out{<div class="sourceCode">}}\preformatted{actionButton(inputId = "btn")
}\if{html}{\out{</div>}}

Then the selector is "btn" \code{selector = 'btn'}. If you are using shiny modules,
use \code{ns()} to wrap it in UI for the button \code{actionButton(inputId = ns("btn"))},
and also add \code{ns()} to selector \code{selector = ns('btn')} for the \link{animateUI}
function. If you are using the server side functions \link{animateServer} and \link{animationRemove},
\strong{DO NOT} add the \code{ns()} wrapper.}

\item{animation}{what kind of animation you want, one of "wrench", "ring",
"horizontal", "horizontal-reverse", "vertical", "flash", "bounce", "bounce-reverse",
"spin", "spin-reverse", "float", "pulse", "shake", "tada", "passing", "passing-reverse",
"burst", "falling", "falling-reverse", "rising"s
See our online demo for details.
or our online demo for details.}

\item{speed}{string, one of "fast", "slow"}

\item{hover}{bool, trigger animation on hover?}

\item{isID}{bool, is your selector an ID?}

\item{session}{the current shiny session}

\item{alert}{bool, for \link{animationRemove} only: if the component is not found or it
does not contain any animation or the animation is not added by spsComps,
alert on UI? More like for debugging purposes.}
}
\value{
see details
}
\description{
Add animation to a HTML or component and remove it
}
\details{
\itemize{
\item animateUI: use on the UI side, which means add the animation when UI loads
complete.
\item animateServer: use on the server side. Use server to trigger the animation
on a component at some point.
\item animationRemove: use on the server side, to remove animation on a certain
component.
}
\subsection{Selector}{

Usually for beginners use the shiny component ID is enough, but sometimes
a HTML element may not has the 'id' attribute. In this case, you can still
animate the element by advanced CSS selector. For these selectors, turn off
the \code{isID = FALSE} and provide the selector in a single string.
Google "CSS selector" to learn more.
}

\subsection{only server functions}{

If you use \link{animateServer} or \link{animationRemove} on the server, but not \link{animateUI}
you don't have to load the required CSS and javascript, since spsComps 0.3.1. In case
they don't work, you can manually add the dependency by  adding
\code{spsDepend("animation")} somewhere in your UI. see examples.
}
}
\examples{
if(interactive()){
  library(shiny)

  ui <- fluidPage(
    spsDepend("animation"), # optional
    column(
      6,
      h3("Adding animations from UI"),
      tags$label("to a button"), br(),
      actionButton("btn1", "random button"), br(),
      animateUI("btn1", animation = "ring"),
      tags$label("to some text"), br(),
      p(id = "mytext", class = "text-red", "some move text"), br(),
      animateUI("mytext", animation = "horizontal", speed = "fast"),
      tags$label("on hover, move mouse on the red thumb"), br(),
      actionButton(
        "btn2", "",
        icon = icon(id = "myicon", "thumbs-up"),
        style = "color: red; boarder: initial; border-color: transparent;"
      ), br(),
      animateUI("btn2", animation = "bounce", speed = "fast", hover = TRUE),
      tags$label("on a plot"), br(),
      plotOutput("plot1"),
      animateUI("plot1", animation = "float", speed = "fast")
    ),
    column(
      6,
      h3("Adding/removing animations from server"),
      tags$label("use a button to control"), br(),
      actionButton("btn3", "animate itself"),
      actionButton("btn4", "stop animation"), br(),
      tags$label("advanced selector in for complex group"), br(),
      sliderInput(
        "myslider",
        label = "animating if less than 5",
        value = 0,
        min = 0, max = 10,
        step = 1
      ),
      sliderInput(
        "myslider2",  min = 0, max = 10, value = 10,
        label = "this one will not be selected"
      )
    )
  )

  server <- function(input, output, session) {
    output$plot1 <- renderPlot(plot(1:10, 10:1))
    observeEvent(input$myslider, {
      if (input$myslider <= 5) {
        animateServer(
          # the slider container does not has the ID, it is inside
          selector = ".shiny-input-container:has(#myslider)",
          animation = "horizontal", speed = "slow", isID = FALSE
        )
      } else {
        animationRemove(
          selector = ".shiny-input-container:has(#myslider)",
          isID = FALSE
        )
      }
    })
    observeEvent(input$btn3, {
      animateServer("btn3", animation = "flash", speed = "slow")
    })
    observeEvent(input$btn4, {
      animationRemove("btn3")
    })
  }

  shinyApp(ui, server)
}
}
