% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commuter.R
\name{commuter}
\alias{commuter}
\title{commuter}
\usage{
commuter(seiiar = spread::norway_seiiar_oslo_2017,
  commuters = spread::norway_commuters_2017, r0 = NULL, beta = NULL,
  latent_period = 1.9, infectious_period = 3, asymptomatic_prob = 0,
  asymptomatic_relative_infectiousness = 0, days_simulation = 7 * 8,
  N = 1)
}
\arguments{
\item{seiiar}{Data frame containing `location_code`, `S`, `E`, `I`, `Ia`, and `R` for the entire population}

\item{commuters}{Data frame comtaining `from`, `to`, `n` for the number of people who travel}

\item{r0}{Float, basic reproduction number}

\item{beta}{Float, infection parameter, 0.6}

\item{latent_period}{Float, 1.9}

\item{infectious_period}{Float, 3}

\item{asymptomatic_prob}{Float, Proportion/probability of asymptomatic given infectious}

\item{asymptomatic_relative_infectiousness}{Float, Relative infectiousness of asymptomatic infectious}

\item{days_simulation}{Int, Number of days to simulate}

\item{N}{Int = 1 int, Number of repetitions}
}
\description{
This model is a stochastic SEIIaR (susceptible, exposed, infectious, infectious asymptomatic, recovered)
metapopulation model that including commuting.
}
\details{
Each location has a local infection system, while the locations are connected
by people who commute each day. The model differentiates between day and night. During the day you
can infect/be infected in the location where you work, while during the night you can infect/be infected
in the location where you live. It is the same commuters who travel back and forth each day. At the
start of a day, all commuters are sent to their work location, where they mix for 12 hours. The
commuters are then sent to their respective home locations, where they mix for 12 hours.

The model is loosely based upon a published model by Engebretsen (2019) \doi{10.1371/journal.pcbi.1006879}.

For more information, look at \code{vignette("commuter_model","spread")}
}
\examples{
spread::commuter(
  seiiar = spread::norway_seiiar_measles_oslo_2017,
  commuters = spread::norway_commuters_2017,
  r0 = 14,
  latent_period = 8,
  infectious_period = 5,
  asymptomatic_prob = 0,
  asymptomatic_relative_infectiousness = 0,
  days_simulation = 7*9,
  N = 1
)
}
