% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plot.intensity_surface}
\alias{plot.intensity_surface}
\title{Plots a normal mixture intensity in 3d}
\usage{
\method{plot}{intensity_surface}(x, truncate = TRUE, L = 256, zlims = c(0,
  0), main = "Poisson intensity surface (mixture of normal components)",
  grayscale = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{intensity_surface} or \code{normmix}.}

\item{truncate}{Requests to truncate the components
of the mixture intensity to have all their mass
within the window of the intensity object intsurf. Default is TRUE.}

\item{L}{Length of the side of the square grid.
The intensity is calculated on an L * L grid.
The larger this value is, the better the picture resolution.}

\item{zlims}{The limits of the z axis. Defaults to [0,1.1*max(intensity)].}

\item{main}{Title for the plot.}

\item{grayscale}{Logical flag to request a gray scale plot.}

\item{...}{Additional parameters passed to \code{to_int_surf()}.}
}
\description{
Plot the 3d intensity surface of a Poisson point process
with mixture intensity of normal components.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot.intensity_surface}
}
\examples{
\donttest{
truemix <- rnormmix(m = 5, sig0 = .1, df = 5, xlim= c(-1, 5), ylim =c(2, 5))
intsurf=to_int_surf(truemix, lambda = 200, win =spatstat::owin( c(-1, 5),c(2, 5)))
plot(intsurf,main = "True Poisson intensity surface (mixture of normal components)")
#use the demo intensity surface
demo_intsurf
summary(demo_intsurf)
#3d plot of the intensity surface
plot(demo_intsurf,main = "True Poisson intensity surface (mixture of normal components)")}

}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}}
}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
