% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_post.R
\name{summary.bdmcmc_res}
\alias{summary.bdmcmc_res}
\title{Summarize BDMCMC results}
\usage{
\method{summary}{bdmcmc_res}(object, num_comp, burnin = floor(object$L/10),
  alpha = 0.05, dgt = 4, ...)
}
\arguments{
\item{object}{Object of class \code{bdmcmc_res}.}

\item{num_comp}{Number of components requested. Only
the posterior realizations that have this many components will be returned. The function
fails if the BDMCMC chain never visited this number of components.
We can also pass a vector of integer values and present the posterior means summary. If
this argument is missing, the MAP estimator is chosen by default.}

\item{burnin}{Number of initial
realizations to discard. By default, it
is 1/10 of the total number of iterations.}

\item{alpha}{Level alpha for the credible
sets. Default is 0.05, for 95% credible
sets of the mixture parameters.}

\item{dgt}{Number of digits to use
(formatting the output).}

\item{...}{Additional arguments for the S3 method.}
}
\description{
Prints a brief summary of the results of a BDMCMC fit.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#summary.bdmcmc_res}
}
\examples{

\dontrun{
# generate data
truemix<- rnormmix(m = 3, sig0 = .1, df = 5, xlim= c(0, 5), ylim = c(0, 5))
summary(truemix)
intsurf=to_int_surf(truemix, lambda = 100, win =spatstat::owin( c(0, 5),c(0, 5)))
pp1 <- rsppmix(intsurf = intsurf)# draw points
#Run BDMCMC and get posterior realizations
postfit=est_mix_bdmcmc(pp1,m=5)
#summary of the posterior results
summary(postfit)
summary(postfit, num_comp=2)
summary(postfit, num_comp=c(2,4))}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{rnormmix}},
\code{\link{to_int_surf}},
\code{\link{rsppmix}},
\code{\link{est_mix_bdmcmc}},
\code{\link[spatstat]{owin}}
}

