% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_chains}
\alias{plot_chains}
\title{Plot MCMC chains}
\usage{
plot_chains(fit, burnin = floor(fit$L/10), chain = c("p", "x", "y"),
  ncol = fit$m\%\%3 + 1, separate = TRUE, open_new_window = FALSE)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{chain}{Character vector choosing from c("p", "x", "y"). Multiple
choices are supported. This will plot the MCMC chain for the requested variables.}

\item{ncol}{Number of columns in each plot.}

\item{separate}{Logical flag to request the the chains should be shown in
separate plots or shown in one plot with different colors per component. The
latter (\code{separate=FALSE}) is useful for spotting label switching visually.}

\item{open_new_window}{Open a new window for the plot.}
}
\description{
Plot the MCMC chains for all component means and probabilities, generated by \code{\link{est_mix_damcmc}} or
\code{\link{est_mix_bdmcmc}}.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_chains}
}
\examples{

\dontrun{
fit <- est_mix_damcmc(pp = spatstat::redwood, m = 10)
plot(fit)
plot_chains(fit)
#plot the chains in the same plot with different colors
plot_chains(fit, separate = FALSE)
# Only plot the realizations for the component means
plot_chains(fit, chain = c("x", "y"))
#check labels
check_labels(fit)
#fix labels and plot the chains again
post_fixed = FixLS_da(fit, plot_result = TRUE)
plot_chains(post_fixed)
plot_chains(post_fixed, separate = FALSE)
#We work with the California Earthquake data. We fit an IPPP with intensity surface
#modeled by a mixture with 8 normal components.
CAfit=est_mix_damcmc(CAQuakes2014.RichterOver3.0, m=5, L = 20000)
#Now retrieve the surface of Maximum a Posteriori (MAP) estimates of the mixture parameter.
#Note that the resulting surface is not affected by label switching.
MAPsurf=GetMAPEst(CAfit)
#Plot the states and the earthquake locations along with the fitted MAP IPPP intensity surface
ret=PlotUSAStates(states=c('California','Nevada','Arizona'), showcentroids=FALSE,
 shownames=TRUE, main= "Earthquakes in CA, 2014", pp=CAQuakes2014.RichterOver3.0, surf=MAPsurf,
 boundarycolor="white", namescolor="white")
CAfit=est_mix_damcmc(pp = CAQuakes2014.RichterOver3.0, m = 5)
plot(CAfit)
check_labels(CAfit)
plot_chains(CAfit, separate = FALSE)
#fix labels and plot the chains again
post_fixedCA = FixLS_da(CAfit, plot_result = TRUE)
plot_chains(post_fixedCA, separate = FALSE)}

}
\author{
Jiaxun Chen, Sakis Micheas
}
\seealso{
\code{\link{PlotUSAStates}},
\code{\link{normmix}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}},
\code{\link{FixLS_da}}
}

