% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_plots.R
\name{plot_avgsurf}
\alias{plot_avgsurf}
\title{Plot the average intensity surface}
\usage{
plot_avgsurf(fit, win = fit$data$window, LL = 100,
  burnin = floor(fit$L/10), zlims = c(0, 0), grayscale = FALSE,
  showplot = TRUE)
}
\arguments{
\item{fit}{An object the contains all posterior realizations, e.g., the return
value from \code{\link{est_mix_damcmc}} or \code{\link{est_mix_bdmcmc}}.}

\item{win}{An object of class \code{\link[spatstat]{owin}}.}

\item{LL}{Length of the side of the square grid.
The density or intensity is calculated on an L * L grid.
The larger this value is, the slower the calculation,
but the better the approximation.}

\item{burnin}{Number of initial realizations to discard. By default, it is 1/10 of the total number of iterations.}

\item{zlims}{The limits of the z axis. Defaults to [0,1.1*max(intensity)].}

\item{grayscale}{Logical flag to request a gray scale plot.}

\item{showplot}{Logical flag to request that the plot will be shown. Set to FALSE if you want to return the \code{\link[spatstat]{im.object}}, but do not want to produce the 3d plot.}
}
\value{
An image as an object of class \code{\link[spatstat]{im.object}}.
}
\description{
This function calculates the intensity surface
at each posterior realization and then computes
the average for the intensity surface over a fine grid.
The result is a much smoother posterior estimator
of the intensity surface, which is not necessarily
the same as the surface of posterior means,
which is obtained by \code{\link{GetPMEst}}.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_avgsurf}
}
\examples{

\dontrun{
truemix <- rnormmix(m = 5, sig0 = .1, df = 5, xlim= c(-1, 1), ylim =c(0, 3))
trueintsurf=to_int_surf(truemix, lambda = 200, win =spatstat::owin( c(-1, 1),c(0, 3)))
plot(trueintsurf, main = "True Poisson intensity surface (mixture of normal components)")
pp1 <- rsppmix(trueintsurf)
# Run Data augmentation MCMC and get posterior realizations
postfit=est_mix_damcmc(pp1,m=5)
# Plot the average of the surfaces of the posterior realizations
avgsurf=plot_avgsurf(postfit, LL = 50)
p<-plot_density(as.data.frame(avgsurf))+ggplot2::ggtitle(
 "Average surface of the posterior realization surfaces\\n x denotes a true component mean")
#show the point pattern points
pp_df <- data.frame(pp1$x,pp1$y)
names(pp_df) <- c("x", "y")
p<-p + ggplot2::geom_point(data = pp_df,size=0.8)
#show the true means
mean_df <- data.frame(do.call(rbind, trueintsurf$mus))
names(mean_df) <- c("x", "y")
p + ggplot2::geom_point(data = mean_df, color = "red", shape = "x", size = 5)
#repeat for the contour plot
p<-plot_density(as.data.frame(avgsurf),contour = TRUE)+ggplot2::ggtitle(
 "Average surface of the posterior realization surfaces\\n x denotes a true component mean")
#show the point pattern points
pp_df <- data.frame(pp1$x,pp1$y)
names(pp_df) <- c("x", "y")
p<-p + ggplot2::geom_point(data = pp_df,size=0.8)
#show the true means
mean_df <- data.frame(do.call(rbind, trueintsurf$mus))
names(mean_df) <- c("x", "y")
p + ggplot2::geom_point(data = mean_df, color = "red", shape = "x", size = 5)
#plot the 3d surface again based on the returned object
plotmix_3d(avgsurf,title1 = paste("Average of", .9*postfit$L,
 "posterior realizations of the intensity surface"))}

}
\author{
Jiaxun Chen, Sakis Micheas
}
\seealso{
\code{\link{rnormmix}},
\code{\link{to_int_surf}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}},
\code{\link{plot_density}},
\code{\link[ggplot2]{ggtitle}},
\code{\link[ggplot2]{geom_point}},
\code{\link{plotmix_3d}},
\code{\link{GetPMEst}}
}

